/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.BabylonWeaponEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.item.relic.RelicItem;

public class KeyOfTheKingsLawItem
extends RelicItem {
    private static final String TAG_WEAPONS_SPAWNED = "weaponsSpawned";
    private static final String TAG_CHARGING = "charging";
    public static final int WEAPON_TYPES = 12;

    public KeyOfTheKingsLawItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        KeyOfTheKingsLawItem.setCharging(stack, true);
        return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity living, int time) {
        int spawned = KeyOfTheKingsLawItem.getWeaponsSpawned(stack);
        if (spawned == 20) {
            KeyOfTheKingsLawItem.setCharging(stack, false);
            KeyOfTheKingsLawItem.setWeaponsSpawned(stack, 0);
        }
    }

    public void onUseTick(Level world, LivingEntity living, ItemStack stack, int count) {
        block5: {
            int spawned;
            block6: {
                spawned = KeyOfTheKingsLawItem.getWeaponsSpawned(stack);
                if (count == this.getUseDuration(stack, living) || spawned >= 20 || world.isClientSide) break block5;
                if (!(living instanceof Player)) break block6;
                Player player = (Player)living;
                if (!ManaItemHandler.instance().requestManaExact(stack, player, 150, true)) break block5;
            }
            Vec3 look = living.getLookAngle().multiply(1.0, 0.0, 1.0);
            double playerRot = Math.toRadians(living.getYRot() + 90.0f);
            if (look.x == 0.0 && look.z == 0.0) {
                look = new Vec3(Math.cos(playerRot), 0.0, Math.sin(playerRot));
            }
            look = look.normalize().scale(-2.0);
            int div = spawned / 5;
            int mod = spawned % 5;
            Vec3 pl = look.add(VecHelper.fromEntityCenter((Entity)living)).add(0.0, 1.6, (double)div * 0.1);
            RandomSource rand = world.random;
            Vec3 axis = look.normalize().cross(new Vec3(-1.0, 0.0, -1.0)).normalize();
            double rot = (double)mod * Math.PI / 4.0 - 1.5707963267948966;
            Vec3 axis1 = VecHelper.rotate(axis.scale((double)div * 3.5 + 5.0), rot, look);
            if (axis1.y < 0.0) {
                axis1 = axis1.multiply(1.0, -1.0, 1.0);
            }
            Vec3 end = pl.add(axis1);
            BabylonWeaponEntity weapon = new BabylonWeaponEntity(living, world);
            weapon.setPos(end.x, end.y, end.z);
            weapon.setYRot(living.getYRot());
            weapon.setVariety(rand.nextInt(12));
            weapon.setDelay(spawned);
            weapon.setRotation(Mth.wrapDegrees((float)(-living.getYRot() + 180.0f)));
            world.addFreshEntity((Entity)weapon);
            weapon.playSound(BotaniaSounds.babylonSpawn, 1.0f, 1.0f + world.random.nextFloat() * 3.0f);
            KeyOfTheKingsLawItem.setWeaponsSpawned(stack, spawned + 1);
        }
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public static boolean isCharging(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CHARGING, false);
    }

    public static int getWeaponsSpawned(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_WEAPONS_SPAWNED, 0);
    }

    public static void setCharging(ItemStack stack, boolean charging) {
        ItemNBTHelper.setBoolean(stack, TAG_CHARGING, charging);
    }

    public static void setWeaponsSpawned(ItemStack stack, int count) {
        ItemNBTHelper.setInt(stack, TAG_WEAPONS_SPAWNED, count);
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, BotaniaAPI.botaniaRL("challenge/king_key"));
    }
}

