/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.item.relic.RelicItem;
import vazkii.botania.mixin.LivingEntityAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class FruitOfGrisaiaItem
extends RelicItem {
    public FruitOfGrisaiaItem(Item.Properties props) {
        super(props);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return FruitOfGrisaiaItem.isBoot(stack) ? UseAnim.DRINK : UseAnim.EAT;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (player.canEat(false) && relic != null && relic.isRightPlayer(player)) {
            return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void onUseTick(@NotNull Level world, @NotNull LivingEntity living, @NotNull ItemStack stack, int count) {
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        if (ManaItemHandler.instance().requestManaExact(stack, player, 500, true)) {
            if (count % 5 == 0) {
                player.gameEvent((Holder)GameEvent.EAT);
                player.getFoodData().eat(2, 2.4f);
            }
            if (count == 5 && player.canEat(false)) {
                ((LivingEntityAccessor)player).setUseItemRemaining(20);
            }
        }
    }

    public static boolean isBoot(ItemStack stack) {
        String name = stack.getHoverName().getString().toLowerCase(Locale.ROOT).trim();
        return name.equals("das boot");
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, BotaniaAPI.botaniaRL("challenge/infinite_fruit"));
    }
}

