/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.Relic;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.item.relic.RelicItem;
import vazkii.botania.common.loot.BotaniaLootTables;
import vazkii.botania.xplat.XplatAbstractions;

public class DiceOfFateItem
extends RelicItem {
    public static final Supplier<List<ItemStack>> RELIC_STACKS = Suppliers.memoize(() -> List.of(new ItemStack((ItemLike)BotaniaItems.infiniteFruit), new ItemStack((ItemLike)BotaniaItems.kingKey), new ItemStack((ItemLike)BotaniaItems.flugelEye), new ItemStack((ItemLike)BotaniaItems.thorRing), new ItemStack((ItemLike)BotaniaItems.odinRing), new ItemStack((ItemLike)BotaniaItems.lokiRing)));

    public DiceOfFateItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic != null && relic.isRightPlayer(player)) {
            if (world.isClientSide) {
                return InteractionResultHolder.success((Object)stack);
            }
            world.playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.diceOfFate, SoundSource.PLAYERS, 1.0f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
            ArrayList<Integer> possible = new ArrayList<Integer>();
            for (int i = 0; i < 6; ++i) {
                if (this.hasRelicAlready(player, i)) continue;
                possible.add(i);
            }
            if (!possible.isEmpty()) {
                int relicIdx = (Integer)possible.get(world.random.nextInt(possible.size()));
                player.sendSystemMessage((Component)Component.translatable((String)"botaniamisc.diceRoll", (Object[])new Object[]{relicIdx + 1}).withStyle(ChatFormatting.DARK_GREEN));
                ItemStack toGive = RELIC_STACKS.get().get(relicIdx).copy();
                return InteractionResultHolder.consume((Object)toGive);
            }
            int roll = world.random.nextInt(6) + 1;
            LootTable table = world.getServer().reloadableRegistries().getLootTable(BotaniaLootTables.getDiceRollTable(roll));
            LootParams context = new LootParams.Builder((ServerLevel)world).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withLuck(player.getLuck()).create(LootContextParamSets.GIFT);
            ObjectArrayList generated = table.getRandomItems(context);
            for (ItemStack drop : generated) {
                player.getInventory().placeItemBackInInventory(drop);
            }
            String langKey = generated.isEmpty() ? "botaniamisc.dudDiceRoll" : "botaniamisc.diceRoll";
            player.sendSystemMessage((Component)Component.translatable((String)langKey, (Object[])new Object[]{roll}).withStyle(ChatFormatting.DARK_GREEN));
            stack.shrink(1);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flags) {
        super.appendHoverText(stack, tooltipContext, tooltip, flags);
        tooltip.add((Component)Component.literal((String)""));
        TooltipHandler.addOnShift(tooltip, () -> {
            String name = stack.getDescriptionId() + ".poem";
            for (int i = 0; i < 4; ++i) {
                tooltip.add((Component)Component.translatable((String)(name + i)).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            }
        });
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, null){

            @Override
            public boolean shouldDamageWrongPlayer() {
                return false;
            }
        };
    }

    private boolean hasRelicAlready(Player player, int relicId) {
        if (relicId < 0 || relicId > 6 || !(player instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer mpPlayer = (ServerPlayer)player;
        ItemStack stack = RELIC_STACKS.get().get(relicId);
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic != null && relic.getAdvancement() != null) {
            return PlayerHelper.hasAdvancement(mpPlayer, relic.getAdvancement());
        }
        return false;
    }
}

