/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.material;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.EnderAirBottleEntity;
import vazkii.botania.common.entity.EnderAirEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;

public class EnderAirItem
extends Item
implements ProjectileItem {
    public EnderAirItem(Item.Properties props) {
        super(props);
    }

    public static InteractionResultHolder<ItemStack> onPlayerInteract(Player player, Level world, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.isEmpty() || !stack.is(Items.GLASS_BOTTLE)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (world.dimension() == Level.END && EnderAirItem.isClearFromDragonBreath(world, player.getBoundingBox().inflate(3.5)) && EnderAirItem.notAimingAtFluid(world, player) || EnderAirItem.pickupFromEntity(world, player.getBoundingBox().inflate(1.0))) {
            if (!world.isClientSide) {
                ItemStack enderAir = new ItemStack((ItemLike)BotaniaItems.enderAirBottle);
                player.getInventory().placeItemBackInInventory(enderAir);
                stack.shrink(1);
                world.playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 0.5f, 1.0f);
                world.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, player.position());
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private static boolean notAimingAtFluid(Level world, Player player) {
        BlockHitResult hitResult = EnderAirItem.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = hitResult.getBlockPos();
            return world.mayInteract(player, pos) && world.getFluidState(pos).isEmpty();
        }
        return true;
    }

    public static boolean isClearFromDragonBreath(Level world, AABB aabb) {
        List list = world.getEntitiesOfClass(AreaEffectCloud.class, aabb, entity -> entity != null && entity.isAlive() && entity.getParticle().getType() == ParticleTypes.DRAGON_BREATH);
        return list.isEmpty();
    }

    public static boolean pickupFromEntity(Level level, AABB area) {
        List entities = level.getEntitiesOfClass(EnderAirEntity.class, area, EntitySelector.ENTITY_STILL_ALIVE);
        if (!entities.isEmpty()) {
            ((EnderAirEntity)((Object)entities.get(0))).discard();
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        world.playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.enderAirThrow, SoundSource.PLAYERS, 1.0f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            EnderAirBottleEntity b = new EnderAirBottleEntity((LivingEntity)player, world);
            b.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            world.addFreshEntity((Entity)b);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        return new EnderAirBottleEntity(pos.x(), pos.y(), pos.z(), level);
    }
}

