/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.CompositableLensItem;
import vazkii.botania.api.mana.ControlLensItem;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.ManaSpreader;
import vazkii.botania.api.mana.TinyPlanetExcempt;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.DataComponentHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.lens.Lens;
import vazkii.botania.common.item.lens.StormLens;

public class LensItem
extends Item
implements ControlLensItem,
CompositableLensItem,
TinyPlanetExcempt {
    public static final int PROP_NONE = 0;
    public static final int PROP_POWER = 1;
    public static final int PROP_ORIENTATION = 2;
    public static final int PROP_TOUCH = 4;
    public static final int PROP_INTERACTION = 8;
    public static final int PROP_DAMAGE = 16;
    public static final int PROP_CONTROL = 32;
    private static final String TAG_COLOR = "color";
    private static final String TAG_COMPOSITE_LENS = "compositeLens";
    private final Lens lens;
    private final int props;

    public LensItem(Item.Properties builder, Lens lens, int props) {
        super(builder);
        this.lens = lens;
        this.props = props;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> stacks, TooltipFlag flags) {
        boolean isRainbow = LensItem.isLensRainbow(stack);
        DyeColor lensColor = LensItem.getLensColor(stack);
        if (isRainbow || lensColor != null) {
            MutableComponent colorName = Component.translatable((String)(isRainbow ? "botania.color.rainbow" : "color.minecraft." + lensColor.getName()));
            TextColor realColor = TextColor.fromRgb((int)this.getLensColor(stack, null));
            stacks.add((Component)Component.translatable((String)"botaniamisc.color", (Object[])new Object[]{colorName}).withStyle(s -> s.withColor(realColor)));
        }
        if (this.lens instanceof StormLens) {
            stacks.add((Component)Component.translatable((String)"botaniamisc.creative").withStyle(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (compositeLens.isEmpty()) {
            return super.getName(stack);
        }
        String shortKeyA = stack.getDescriptionId() + ".short";
        String shortKeyB = compositeLens.getDescriptionId() + ".short";
        return Component.translatable((String)"item.botania.composite_lens", (Object[])new Object[]{Component.translatable((String)shortKeyA), Component.translatable((String)shortKeyB)});
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props, Level level) {
        Item item;
        if (LensItem.isLensTinted(stack)) {
            props.color = this.getLensColor(stack, level);
        }
        LensItem.getLens(stack).apply(stack, props);
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.isEmpty() && (item = compositeLens.getItem()) instanceof BasicLensItem) {
            BasicLensItem basicLensItem = (BasicLensItem)item;
            basicLensItem.apply(compositeLens, props, level);
        }
    }

    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        Item item;
        shouldKill = LensItem.getLens(stack).collideBurst(burst, pos, isManaBlock, shouldKill, stack);
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.isEmpty() && (item = compositeLens.getItem()) instanceof BasicLensItem) {
            BasicLensItem basicLensItem = (BasicLensItem)item;
            shouldKill = basicLensItem.collideBurst(burst, pos, isManaBlock, shouldKill, compositeLens);
        }
        return shouldKill;
    }

    @Override
    public void updateBurst(ManaBurst burst, ItemStack stack) {
        Item item;
        if (LensItem.isLensRainbow(stack) && burst.entity().level().isClientSide) {
            burst.setColor(this.getLensColor(stack, burst.entity().level()));
        }
        LensItem.getLens(stack).updateBurst(burst, stack);
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.isEmpty() && (item = compositeLens.getItem()) instanceof BasicLensItem) {
            BasicLensItem basicLensItem = (BasicLensItem)item;
            basicLensItem.updateBurst(burst, compositeLens);
        }
    }

    @Override
    public int getLensColor(ItemStack stack, @UnknownNullability Level level) {
        if (LensItem.isLensRainbow(stack)) {
            if (level == null) {
                return 0xFFFFFF;
            }
            return Mth.hsvToRgb((float)((float)(level.getGameTime() * 2L % 360L) / 360.0f), (float)1.0f, (float)1.0f);
        }
        DyeColor lensColor = LensItem.getLensColor(stack);
        return lensColor != null ? ColorHelper.getColorValue(lensColor) : 0xFFFFFF;
    }

    public static boolean isLensTinted(ItemStack stack) {
        return stack.has(BotaniaDataComponents.LENS_TINT) || LensItem.isLensRainbow(stack);
    }

    @Nullable
    public static DyeColor getLensColor(ItemStack stack) {
        return (DyeColor)stack.get(BotaniaDataComponents.LENS_TINT);
    }

    public static boolean isLensRainbow(ItemStack stack) {
        return stack.has(BotaniaDataComponents.LENS_RAINBOW_TINT);
    }

    public static void setLensColor(ItemStack stack, DyeColor color) {
        stack.remove(BotaniaDataComponents.LENS_RAINBOW_TINT);
        stack.set(BotaniaDataComponents.LENS_TINT, (Object)color);
    }

    public static void setLensRainbow(ItemStack stack) {
        stack.remove(BotaniaDataComponents.LENS_TINT);
        stack.set(BotaniaDataComponents.LENS_RAINBOW_TINT, (Object)Unit.INSTANCE);
    }

    @Override
    public boolean doParticles(ManaBurst burst, ItemStack stack) {
        return true;
    }

    public static boolean isBlacklisted(ItemStack lens1, ItemStack lens2) {
        CompositableLensItem item1 = (CompositableLensItem)lens1.getItem();
        CompositableLensItem item2 = (CompositableLensItem)lens2.getItem();
        return (item1.getProps(lens1) & item2.getProps(lens2)) != 0;
    }

    public static Lens getLens(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof LensItem) {
            LensItem lens = (LensItem)item;
            return lens.lens;
        }
        return new Lens();
    }

    @Override
    public boolean canCombineLenses(ItemStack sourceLens, ItemStack compositeLens) {
        CompositableLensItem compositeItem;
        CompositableLensItem sourceItem = (CompositableLensItem)sourceLens.getItem();
        if (sourceItem == (compositeItem = (CompositableLensItem)compositeLens.getItem())) {
            return false;
        }
        if (!sourceItem.isCombinable(sourceLens) || !compositeItem.isCombinable(compositeLens)) {
            return false;
        }
        return !LensItem.isBlacklisted(sourceLens, compositeLens);
    }

    @Override
    public ItemStack getCompositeLens(ItemStack stack) {
        return (ItemStack)stack.getOrDefault(BotaniaDataComponents.ATTACHED_LENS, (Object)ItemStack.EMPTY);
    }

    @Override
    public ItemStack setCompositeLens(ItemStack sourceLens, ItemStack compositeLens) {
        DataComponentHelper.setOptional(sourceLens, BotaniaDataComponents.ATTACHED_LENS, compositeLens);
        return sourceLens;
    }

    @Override
    public int getManaToTransfer(ManaBurst burst, ItemStack stack, ManaReceiver receiver) {
        return LensItem.getLens(stack).getManaToTransfer(burst, stack, receiver);
    }

    @Override
    public boolean shouldPull(ItemStack stack) {
        return !stack.is(BotaniaItems.lensStorm);
    }

    @Override
    public boolean isControlLens(ItemStack stack) {
        return (this.getProps(stack) & 0x20) != 0;
    }

    @Override
    public boolean allowBurstShooting(ItemStack stack, ManaSpreader spreader, boolean redstone) {
        return LensItem.getLens(stack).allowBurstShooting(stack, spreader, redstone);
    }

    @Override
    public void onControlledSpreaderTick(ItemStack stack, ManaSpreader spreader, boolean redstone) {
        LensItem.getLens(stack).onControlledSpreaderTick(stack, spreader, redstone);
    }

    @Override
    public void onControlledSpreaderPulse(ItemStack stack, ManaSpreader spreader) {
        LensItem.getLens(stack).onControlledSpreaderPulse(stack, spreader);
    }

    @Override
    public int getProps(ItemStack stack) {
        return this.props;
    }

    @Override
    public boolean isCombinable(ItemStack stack) {
        return !stack.is(BotaniaItems.lensNormal);
    }
}

