/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.lens.Lens;

public class InfluenceLens
extends Lens {
    @Override
    public void updateBurst(ManaBurst burst, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        if (!burst.isFake()) {
            double range = 3.5;
            AABB bounds = new AABB(entity.getX() - range, entity.getY() - range, entity.getZ() - range, entity.getX() + range, entity.getY() + range, entity.getZ() + range);
            List items = entity.level().getEntitiesOfClass(ItemEntity.class, bounds);
            List expOrbs = entity.level().getEntitiesOfClass(ExperienceOrb.class, bounds);
            List arrows = entity.level().getEntitiesOfClass(AbstractArrow.class, bounds);
            List fallingBlocks = entity.level().getEntitiesOfClass(FallingBlockEntity.class, bounds);
            List primedTnt = entity.level().getEntitiesOfClass(PrimedTnt.class, bounds);
            List bursts = entity.level().getEntitiesOfClass(ThrowableProjectile.class, bounds, (Predicate)Predicates.instanceOf(ManaBurst.class));
            Iterable concat = Iterables.concat((Iterable[])new Iterable[]{items, expOrbs, arrows, fallingBlocks, primedTnt, bursts});
            for (Entity movable : concat) {
                ManaBurst otherBurst;
                ItemStack lens;
                if (movable == burst || movable instanceof ManaBurst && !(lens = (otherBurst = (ManaBurst)movable).getSourceLens()).isEmpty() && lens.is(BotaniaItems.lensInfluence)) continue;
                movable.setDeltaMovement(entity.getDeltaMovement());
            }
        }
    }
}

