/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vazkii.botania.api.mana.ManaSpreader;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.lens.Lens;
import vazkii.botania.common.item.lens.LensItem;

public class FlareLens
extends Lens {
    @Override
    public boolean allowBurstShooting(ItemStack stack, ManaSpreader spreader, boolean redstone) {
        return false;
    }

    @Override
    public void onControlledSpreaderTick(ItemStack stack, ManaSpreader spreader, boolean redstone) {
        if (!redstone) {
            this.emitParticles(stack, spreader);
        }
    }

    @Override
    public void onControlledSpreaderPulse(ItemStack stack, ManaSpreader spreader) {
        this.emitParticles(stack, spreader);
    }

    private void emitParticles(ItemStack stack, ManaSpreader spreader) {
        DyeColor storedColor;
        float rotationYaw = -(spreader.getRotationX() + 90.0f);
        float rotationPitch = spreader.getRotationY();
        float f = 0.3f;
        float mx = (float)((double)(Mth.sin((float)(rotationYaw / 180.0f * (float)Math.PI)) * Mth.cos((float)(rotationPitch / 180.0f * (float)Math.PI)) * f) / 2.0);
        float mz = (float)((double)(-(Mth.cos((float)(rotationYaw / 180.0f * (float)Math.PI)) * Mth.cos((float)(rotationPitch / 180.0f * (float)Math.PI)) * f)) / 2.0);
        float my = (float)((double)(Mth.sin((float)(rotationPitch / 180.0f * (float)Math.PI)) * f) / 2.0);
        Level level = spreader.getManaReceiverLevel();
        int hex = LensItem.isLensRainbow(stack) ? Mth.hsvToRgb((float)((float)(level.getGameTime() * 2L % 360L) / 360.0f), (float)1.0f, (float)1.0f) : ((storedColor = LensItem.getLensColor(stack)) != null ? ColorHelper.getColorValue(storedColor) : 0xFFFFFF);
        float r = (float)((hex & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((hex & 0xFF00) >> 8) / 255.0f;
        float b = (float)(hex & 0xFF) / 255.0f;
        WispParticleData data = WispParticleData.wisp(0.4f, r, g, b);
        BlockPos pos = spreader.getManaReceiverPos();
        level.addParticle((ParticleOptions)data, (double)pos.getX() + 0.5 + (double)mx * 4.5, (double)pos.getY() + 0.5 + (double)my * 4.5, (double)pos.getZ() + 0.5 + (double)mz * 4.5, (double)mx, (double)my, (double)mz);
    }
}

