/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.item.lens.Lens;

public class CelebratoryLens
extends Lens {
    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        if (pos.getType() == HitResult.Type.BLOCK) {
            if (!(entity.level().isClientSide || burst.isFake() || isManaBlock)) {
                ItemStack fireworkStack = this.generateFirework(burst.getColor());
                FireworkRocketEntity rocket = new FireworkRocketEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), fireworkStack);
                entity.level().addFreshEntity((Entity)rocket);
            }
            return true;
        }
        return shouldKill;
    }

    private ItemStack generateFirework(int color) {
        ItemStack stack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        double rand = Math.random();
        FireworkExplosion.Shape shape = rand > 0.9 ? FireworkExplosion.Shape.STAR : (rand > 0.25 ? FireworkExplosion.Shape.SMALL_BALL : FireworkExplosion.Shape.LARGE_BALL);
        FireworkExplosion explosion = new FireworkExplosion(shape, IntList.of((int)color), IntList.of(), Math.random() < 0.05, Math.random() < 0.05);
        stack.set(DataComponents.FIREWORKS, (Object)new Fireworks((int)(Math.random() * 3.0 + 2.0), List.of(explosion)));
        return stack;
    }
}

