/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.SequentialBreaker;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.DataComponentHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.StoneOfTemperanceItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelPickaxeItem;
import vazkii.botania.common.item.relic.RingOfThorItem;
import vazkii.botania.xplat.XplatAbstractions;

public class TerraShattererItem
extends ManasteelPickaxeItem
implements SequentialBreaker,
CustomCreativeTabContents {
    public static final int MAX_MANA = Integer.MAX_VALUE;
    private static final int MANA_PER_DAMAGE = 100;
    public static final int[] LEVELS = new int[]{0, 10000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] CREATIVE_MANA = new int[]{9999, 999999, 9999999, 99999999, 999999999, 0x7FFFFFFE};

    public TerraShattererItem(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), props, -2.8f);
    }

    @Override
    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        output.accept((ItemLike)me);
        for (int mana : CREATIVE_MANA) {
            ItemStack stack = new ItemStack((ItemLike)me);
            TerraShattererItem.setMana(stack, mana);
            output.accept(stack);
        }
        ItemStack stack = new ItemStack((ItemLike)me);
        TerraShattererItem.setMana(stack, CREATIVE_MANA[1]);
        TerraShattererItem.setTipped(stack);
        output.accept(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> stacks, TooltipFlag flags) {
        MutableComponent rank = Component.translatable((String)("botania.rank" + TerraShattererItem.getLevel(stack)));
        MutableComponent rankFormat = Component.translatable((String)"botaniamisc.toolRank", (Object[])new Object[]{rank});
        stacks.add((Component)rankFormat);
        if (TerraShattererItem.getMana_(stack) == Integer.MAX_VALUE) {
            stacks.add((Component)Component.translatable((String)"botaniamisc.getALife").withStyle(ChatFormatting.RED));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isSecondaryUseActive() && hand == InteractionHand.MAIN_HAND) {
            int tier = TerraShattererItem.getLevel(stack);
            BlockHitResult blockhitresult = TerraShattererItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (tier != 0 && blockhitresult.getType() != HitResult.Type.BLOCK) {
                this.setEnabled(stack, !TerraShattererItem.isEnabled(stack));
                if (!level.isClientSide) {
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.terraPickMode, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (TerraShattererItem.isEnabled(stack)) {
            int level = TerraShattererItem.getLevel(stack);
            if (level == 0) {
                this.setEnabled(stack, false);
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.swinging) {
                    ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
                    manaItem.addMana(-level);
                }
            }
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        int level = TerraShattererItem.getLevel(stack);
        int max = LEVELS[Math.min(LEVELS.length - 1, level + 1)];
        int curr = TerraShattererItem.getMana_(stack);
        float percent = level == 0 ? 0.0f : (float)curr / (float)max;
        return Optional.of(new ManaBarTooltip(percent, level));
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        BlockHitResult raycast = ToolCommons.raytraceFromEntity((Entity)player, 10.0, false);
        if (!player.level().isClientSide && raycast.getType() == HitResult.Type.BLOCK) {
            Direction face = raycast.getDirection();
            this.breakOtherBlock(player, stack, pos, pos, face);
            if (player.isSecondaryUseActive()) {
                BotaniaAPI.instance().breakOnAllCursors(player, stack, pos, face);
            }
        }
        return false;
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    @Override
    public void breakOtherBlock(Player player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        if (!TerraShattererItem.isEnabled(stack)) {
            return;
        }
        Predicate<BlockState> canMine = state -> {
            boolean rightToolForDrops = !state.requiresCorrectToolForDrops() || stack.isCorrectToolForDrops(state);
            boolean rightToolForSpeed = stack.getDestroySpeed(state) > 1.0f || state.is(BlockTags.MINEABLE_WITH_SHOVEL) || state.is(BlockTags.MINEABLE_WITH_HOE);
            return rightToolForDrops && rightToolForSpeed;
        };
        Level world = player.level();
        BlockState targetState = world.getBlockState(pos);
        if (!canMine.test(targetState)) {
            return;
        }
        if (world.isEmptyBlock(pos)) {
            return;
        }
        boolean thor = !RingOfThorItem.getThorRing(player).isEmpty();
        boolean doX = thor || side.getStepX() == 0;
        boolean doY = thor || side.getStepY() == 0;
        boolean doZ = thor || side.getStepZ() == 0;
        int origLevel = TerraShattererItem.getLevel(stack);
        int level = origLevel + (thor ? 1 : 0);
        if (StoneOfTemperanceItem.hasTemperanceActive(player) && level > 2) {
            level = 2;
        }
        int range = level - 1;
        int rangeY = Math.max(1, range);
        if (range == 0 && level != 1) {
            return;
        }
        Vec3i beginDiff = new Vec3i(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
        Vec3i endDiff = new Vec3i(doX ? range : 0, doY ? rangeY * 2 - 1 : 0, doZ ? range : 0);
        ToolCommons.removeBlocksInIteration(player, stack, world, pos, beginDiff, endDiff, canMine);
        if (origLevel == 5) {
            PlayerHelper.grantCriterion((ServerPlayer)player, BotaniaAPI.botaniaRL("challenge/rank_ss_pick"), "code_triggered");
        }
    }

    public static boolean isTipped(ItemStack stack) {
        return stack.has(BotaniaDataComponents.ELEMENTIUM_TIPPED);
    }

    public static void setTipped(ItemStack stack) {
        stack.set(BotaniaDataComponents.ELEMENTIUM_TIPPED, (Object)Unit.INSTANCE);
    }

    public static boolean isEnabled(ItemStack stack) {
        return stack.has(BotaniaDataComponents.ACTIVE);
    }

    void setEnabled(ItemStack stack, boolean enabled) {
        DataComponentHelper.setFlag(stack, BotaniaDataComponents.ACTIVE, enabled);
    }

    protected static void setMana(ItemStack stack, int mana) {
        stack.set(BotaniaDataComponents.MANA, (Object)mana);
    }

    public static int getMana_(ItemStack stack) {
        return (Integer)stack.getOrDefault(BotaniaDataComponents.MANA, (Object)0);
    }

    public static int getLevel(ItemStack stack) {
        int mana = TerraShattererItem.getMana_(stack);
        for (int i = LEVELS.length - 1; i > 0; --i) {
            if (mana < LEVELS[i]) continue;
            return i;
        }
        return 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.reequipAnimation(oldStack, newStack);
    }

    public boolean allowNbtUpdateAnimation(Player player, InteractionHand hand, ItemStack before, ItemStack after) {
        return this.reequipAnimation(before, after);
    }

    private boolean reequipAnimation(ItemStack before, ItemStack after) {
        return !after.is((Item)this) || TerraShattererItem.isEnabled(before) != TerraShattererItem.isEnabled(after);
    }
}

