/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.List;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelSwordItem;
import vazkii.botania.network.serverbound.LeftClickPacket;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class TerraBladeItem
extends ManasteelSwordItem
implements LensEffectItem {
    private static final int MANA_PER_DAMAGE = 100;

    public TerraBladeItem(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), props);
    }

    public static void leftClick(ItemStack stack) {
        if (!stack.isEmpty() && stack.getItem() instanceof TerraBladeItem) {
            ClientXplatAbstractions.INSTANCE.sendToServer(LeftClickPacket.INSTANCE);
        }
    }

    public static InteractionResult attackEntity(Player player, Level world, InteractionHand hand, Entity target, @Nullable EntityHitResult hit) {
        if (!player.level().isClientSide) {
            TerraBladeItem.trySpawnBurst(player);
        }
        return InteractionResult.PASS;
    }

    public static void trySpawnBurst(Player player) {
        TerraBladeItem.trySpawnBurst(player, player.getAttackStrengthScale(0.0f));
    }

    public static void trySpawnBurst(Player player, float attackStrength) {
        if (!player.isSpectator() && !player.getMainHandItem().isEmpty() && player.getMainHandItem().is(BotaniaItems.terraSword) && attackStrength == 1.0f) {
            ManaBurstEntity burst = TerraBladeItem.getBurst(player, player.getMainHandItem());
            player.level().addFreshEntity((Entity)burst);
            player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.terraBlade, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    public static ManaBurstEntity getBurst(Player player, ItemStack stack) {
        ManaBurstEntity burst = new ManaBurstEntity(player);
        float motionModifier = 7.0f;
        burst.setColor(0x20FF20);
        burst.setMana(100);
        burst.setStartingMana(100);
        burst.setMinManaLoss(40);
        burst.setManaLossPerTick(4.0f);
        burst.setGravity(0.0f);
        burst.setDeltaMovement(burst.getDeltaMovement().scale((double)motionModifier));
        burst.setSourceLens(stack.copy());
        return burst;
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props, Level level) {
    }

    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        return shouldKill;
    }

    @Override
    public void updateBurst(ManaBurst burst, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        AABB axis = new AABB(entity.getX(), entity.getY(), entity.getZ(), entity.xOld, entity.yOld, entity.zOld).inflate(1.0);
        List entities = entity.level().getEntitiesOfClass(LivingEntity.class, axis);
        Entity thrower = entity.getOwner();
        for (LivingEntity living : entities) {
            if (living == thrower) continue;
            if (living instanceof Player) {
                Player throwingPlayer;
                Player livingPlayer = (Player)living;
                if (thrower instanceof Player && !(throwingPlayer = (Player)thrower).canHarmPlayer(livingPlayer)) continue;
            }
            if (living.hurtTime != 0) continue;
            int cost = 33;
            int mana = burst.getMana();
            if (mana < cost) continue;
            burst.setMana(mana - cost);
            float damage = 4.0f + BotaniaAPI.instance().getTerrasteelItemTier().getAttackDamageBonus();
            if (burst.isFake() || entity.level().isClientSide) continue;
            DamageSource source = living.damageSources().magic();
            if (thrower instanceof Player) {
                Player player = (Player)thrower;
                source = player.damageSources().playerAttack(player);
            } else if (thrower instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)thrower;
                source = livingEntity.damageSources().mobAttack(livingEntity);
            }
            living.hurt(source, damage);
            entity.discard();
            break;
        }
    }

    @Override
    public boolean doParticles(ManaBurst burst, ItemStack stack) {
        return true;
    }
}

