/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.elementium;

import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelShearsItem;

public class ElementiumShearsItem
extends ManasteelShearsItem {
    public ElementiumShearsItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
    }

    public void onUseTick(Level world, @NotNull LivingEntity living, @NotNull ItemStack stack, int count) {
        if (world.isClientSide) {
            return;
        }
        if (count != this.getUseDuration(stack, living) && count % 5 == 0) {
            int range = 12;
            List shearables = world.getEntitiesOfClass(Entity.class, new AABB(living.getX() - (double)range, living.getY() - (double)range, living.getZ() - (double)range, living.getX() + (double)range, living.getY() + (double)range, living.getZ() + (double)range), Shearable.class::isInstance);
            if (shearables.size() > 0) {
                for (Entity entity : shearables) {
                    Shearable shearable;
                    if (!(entity instanceof Shearable) || !(shearable = (Shearable)entity).readyForShearing()) continue;
                    shearable.shear(living.getSoundSource());
                    stack.hurtAndBreak(1, living, LivingEntity.getSlotForHand((InteractionHand)living.getUsedItemHand()));
                    break;
                }
            }
        }
    }

    @Override
    public boolean isValidRepairItem(ItemStack toRepair, @NotNull ItemStack repairBy) {
        return repairBy.is(BotaniaItems.elementium) || super.isValidRepairItem(toRepair, repairBy);
    }

    @Override
    public int getSortingPriority(ItemStack stack, BlockState state) {
        return super.getSortingPriority(stack, state) + 100;
    }
}

