/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.elementium;

import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelAxeItem;
import vazkii.botania.common.loot.BotaniaLootTables;

public class ElementiumAxeItem
extends ManasteelAxeItem {
    public ElementiumAxeItem(Item.Properties props) {
        super(BotaniaAPI.instance().getElementiumItemTier(), props.attributes(ElementiumAxeItem.createAttributes((Tier)BotaniaAPI.instance().getElementiumItemTier(), (float)6.0f, (float)-3.1f)));
    }

    public static void onEntityDrops(boolean hitRecently, DamageSource source, LivingEntity target, Consumer<ItemStack> consumer) {
        LivingEntity livingEntity;
        LootParams.Builder ctx = new LootParams.Builder((ServerLevel)target.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)target).withParameter(LootContextParams.ORIGIN, (Object)target.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity());
        if (hitRecently && target.getKillCredit() != null && (livingEntity = target.getKillCredit()) instanceof Player) {
            Player p = (Player)livingEntity;
            ctx = ctx.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)p).withLuck(p.getLuck());
        }
        target.level().getServer().reloadableRegistries().getLootTable(BotaniaLootTables.BEHEADING_LOOT_TABLE).getRandomItems(ctx.create(LootContextParamSets.ENTITY), target.getLootTableSeed(), consumer);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment == Enchantments.LOOTING) {
            return true;
        }
        return stack.is(Items.ENCHANTED_BOOK) || ((Enchantment)enchantment.value()).isSupportedItem(stack);
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }
}

