/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelPickaxeItem;
import vazkii.botania.xplat.XplatAbstractions;

public class VitreousPickaxeItem
extends ManasteelPickaxeItem {
    private static final String TAG_SILK_HACK = "botania:silk_hack";
    private static final int MANA_PER_DAMAGE = 160;
    private static final Tier MATERIAL = new Tier(){

        public int getUses() {
            return 125;
        }

        public float getSpeed() {
            return 4.8f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_WOODEN_TOOL;
        }

        public int getEnchantmentValue() {
            return 10;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GLASS});
        }
    };

    public VitreousPickaxeItem(Item.Properties props) {
        super(MATERIAL, props, -1.0f);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        boolean hasSilk;
        Level level = player.level();
        BlockState state = level.getBlockState(pos);
        HolderLookup enchantmentLookup = level.holderLookup(Registries.ENCHANTMENT);
        boolean bl = hasSilk = EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantmentLookup.getOrThrow(Enchantments.SILK_TOUCH), (ItemStack)itemstack) > 0;
        if (hasSilk || !this.isGlass(state)) {
            return false;
        }
        itemstack.enchant((Holder)enchantmentLookup.getOrThrow(Enchantments.SILK_TOUCH), 1);
        return false;
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity player, int slot, boolean selected) {
        super.inventoryTick(stack, level, player, slot, selected);
    }

    private boolean isGlass(BlockState state) {
        return XplatAbstractions.INSTANCE.isInGlassTag(state);
    }

    @Override
    public int getManaPerDamage() {
        return 160;
    }

    @Override
    public int getSortingPriority(ItemStack stack, BlockState state) {
        return this.isGlass(state) ? Integer.MAX_VALUE : 0;
    }
}

