/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool;

import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.entity.FallingStarEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelSwordItem;

public class StarcallerItem
extends ManasteelSwordItem {
    private static final int MANA_PER_DAMAGE = 120;
    private static final int INTERVAL = 12;

    public StarcallerItem(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), props);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        MobEffectInstance haste;
        super.inventoryTick(stack, world, entity, slot, selected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!stack.has(BotaniaDataComponents.LAST_TRIGGER_TIME)) {
            stack.set(BotaniaDataComponents.LAST_TRIGGER_TIME, (Object)world.getGameTime());
        }
        float check = (haste = player.getEffect(MobEffects.DIG_SPEED)) == null ? 0.16666667f : (haste.getAmplifier() == 1 ? 0.5f : 0.4f);
        long timeSinceLast = world.getGameTime() - (Long)stack.getOrDefault(BotaniaDataComponents.LAST_TRIGGER_TIME, (Object)world.getGameTime());
        if (timeSinceLast > 12L && player.getMainHandItem() == stack && player.attackAnim == check && !world.isClientSide) {
            stack.set(BotaniaDataComponents.LAST_TRIGGER_TIME, (Object)world.getGameTime());
            this.summonFallingStar(stack, world, player);
        }
    }

    private void summonFallingStar(ItemStack stack, Level world, Player player) {
        BlockHitResult pos = ToolCommons.raytraceFromEntity((Entity)player, 48.0, false);
        if (pos.getType() == HitResult.Type.BLOCK) {
            Vec3 posVec = Vec3.atLowerCornerOf((Vec3i)pos.getBlockPos());
            Vec3 motVec = new Vec3((0.5 * Math.random() - 0.25) * 18.0, 24.0, (0.5 * Math.random() - 0.25) * 18.0);
            posVec = posVec.add(motVec);
            motVec = motVec.normalize().reverse().scale(1.5);
            FallingStarEntity star = new FallingStarEntity((LivingEntity)player, world);
            star.setPos(posVec.x, posVec.y, posVec.z);
            star.setDeltaMovement(motVec);
            world.addFreshEntity((Entity)star);
            if (!world.isRaining() && Math.abs(world.getDayTime() - 18000L) < 1800L && Math.random() < 0.125) {
                FallingStarEntity bonusStar = new FallingStarEntity((LivingEntity)player, world);
                bonusStar.setPos(posVec.x, posVec.y, posVec.z);
                bonusStar.setDeltaMovement(motVec.x + Math.random() - 0.5, motVec.y + Math.random() - 0.5, motVec.z + Math.random() - 0.5);
                world.addFreshEntity((Entity)bonusStar);
            }
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
            world.playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.starcaller, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public int getManaPerDamage() {
        return 120;
    }
}

