/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.helper.DataComponentHelper;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.mixin.AbstractHorseAccessor;
import vazkii.botania.mixin.RandomizableContainerBlockEntityAccessor;

public class SpectatorItem
extends BaubleItem {
    public static final int RANGE_ENTITIES = 24;
    public static final int RANGE_BLOCKS = 12;
    public static final int SCAN_INTERVAL_TICKS = 4;

    public SpectatorItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        if (living.level().isClientSide) {
            this.showScanResults(stack, player);
        } else if (living.tickCount % 4 == 0) {
            this.scanForItems(stack, player);
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, LivingEntity entity) {
        stack.remove(BotaniaDataComponents.SPECTATOR_HIGHLIGHT_ENTITIES);
        stack.remove(BotaniaDataComponents.SPECTATOR_HIGHLIGHT_BLOCKS);
    }

    protected void showScanResults(ItemStack stack, Player player) {
        if (player != Proxy.INSTANCE.getClientPlayer()) {
            return;
        }
        List blocks = (List)stack.getOrDefault(BotaniaDataComponents.SPECTATOR_HIGHLIGHT_BLOCKS, Collections.emptyList());
        for (BlockPos pos : blocks) {
            float m = 0.02f;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), false);
            player.level().addParticle((ParticleOptions)data, (double)((float)pos.getX() + (float)Math.random()), (double)((float)pos.getY() + (float)Math.random()), (double)((float)pos.getZ() + (float)Math.random()), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)));
        }
        List entities = (List)stack.getOrDefault(BotaniaDataComponents.SPECTATOR_HIGHLIGHT_ENTITIES, Collections.emptyList());
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Entity e = player.level().getEntity(i);
            if (e == null || !e.isAlive() || !(Math.random() < 0.6)) continue;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), Math.random() < 0.6);
            player.level().addParticle((ParticleOptions)data, e.getX() + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), e.getY() + (double)e.getBbHeight(), e.getZ() + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), 0.0, (double)(0.05f + 0.03f * (float)Math.random()), 0.0);
        }
    }

    public void scanForItems(ItemStack stack, Player player) {
        ItemStack mainHandStack = player.getMainHandItem();
        ItemStack offHandStack = player.getOffhandItem();
        IntList entityIds = this.scanEntities(player, mainHandStack, offHandStack);
        DataComponentHelper.setNonEmpty(stack, BotaniaDataComponents.SPECTATOR_HIGHLIGHT_ENTITIES, entityIds);
        List<BlockPos> blockPositions = this.scanBlockContainers(player, mainHandStack, offHandStack);
        DataComponentHelper.setNonEmpty(stack, BotaniaDataComponents.SPECTATOR_HIGHLIGHT_BLOCKS, blockPositions);
    }

    private IntList scanEntities(Player player, ItemStack mainHandStack, ItemStack offHandStack) {
        boolean emptyHands;
        boolean bl = emptyHands = mainHandStack.isEmpty() && offHandStack.isEmpty();
        if (emptyHands && !player.isShiftKeyDown()) {
            return IntList.of();
        }
        IntArrayList entityIds = new IntArrayList();
        List entities = player.level().getEntitiesOfClass(Entity.class, new AABB(player.blockPosition()).inflate(24.0));
        for (Entity e : entities) {
            AbstractMinecartContainer minecart;
            Container inv;
            Allay allay;
            AbstractChestedHorse horse;
            if (e == player) continue;
            if (e instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)e;
                ItemStack entityStack = item.getItem();
                if (player.isShiftKeyDown() || this.equalStacks(entityStack, mainHandStack, offHandStack)) {
                    entityIds.add(item.getId());
                }
            } else if (emptyHands) continue;
            if (e instanceof Player) {
                Player targetPlayer = (Player)e;
                if (this.scanInventory((Container)targetPlayer.getInventory(), mainHandStack, offHandStack)) {
                    entityIds.add(targetPlayer.getId());
                    continue;
                }
                Container baubleInventory = BotaniaAPI.instance().getAccessoriesInventory(targetPlayer);
                if (!this.scanInventory(baubleInventory, mainHandStack, offHandStack)) continue;
                entityIds.add(targetPlayer.getId());
                continue;
            }
            if (e instanceof AbstractChestedHorse && (horse = (AbstractChestedHorse)e).hasChest()) {
                if (!this.scanInventory((Container)((AbstractHorseAccessor)horse).getInventory(), mainHandStack, offHandStack)) continue;
                entityIds.add(horse.getId());
                continue;
            }
            if (e instanceof Allay && (allay = (Allay)e).hasItemInHand()) {
                if (!this.equalStacks(allay.getMainHandItem(), mainHandStack, offHandStack)) continue;
                entityIds.add(allay.getId());
                continue;
            }
            if (e instanceof Merchant) {
                Merchant villager = (Merchant)e;
                for (MerchantOffer offer : villager.getOffers()) {
                    if (!this.equalStacks(offer.getBaseCostA(), mainHandStack, offHandStack) && !this.equalStacks(offer.getCostB(), mainHandStack, offHandStack) && !this.equalStacks(offer.getResult(), mainHandStack, offHandStack)) continue;
                    entityIds.add(e.getId());
                }
                continue;
            }
            if (!(e instanceof Container) || (inv = (Container)e) instanceof AbstractMinecartContainer && (minecart = (AbstractMinecartContainer)inv).getLootTable() != null || !this.scanInventory(inv, mainHandStack, offHandStack)) continue;
            entityIds.add(e.getId());
        }
        entityIds.trim();
        return IntLists.unmodifiable((IntList)entityIds);
    }

    private List<BlockPos> scanBlockContainers(Player player, ItemStack mainHandStack, ItemStack offHandStack) {
        if (mainHandStack.isEmpty() && offHandStack.isEmpty()) {
            return List.of();
        }
        return BlockPos.betweenClosedStream((AABB)new AABB(player.blockPosition()).inflate(12.0)).filter(pos -> this.scanBlock(player, (BlockPos)pos, mainHandStack, offHandStack)).toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scanBlock(Player player, BlockPos pos, ItemStack mainHandStack, ItemStack offHandStack) {
        Level level = player.level();
        if (!level.isLoaded(pos)) return false;
        if (!level.getBlockState(pos).hasBlockEntity()) {
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof Container)) return false;
        Container inv = (Container)blockEntity;
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity lootInv = (RandomizableContainerBlockEntity)blockEntity;
            if (((RandomizableContainerBlockEntityAccessor)lootInv).getLootTable() != null) return false;
        }
        if (!this.scanInventory(inv, mainHandStack, offHandStack)) return false;
        return true;
    }

    private boolean equalStacks(ItemStack testStack, ItemStack referenceStack1, ItemStack referenceStack2) {
        return !testStack.isEmpty() && (ItemStack.isSameItemSameComponents((ItemStack)testStack, (ItemStack)referenceStack1) || ItemStack.isSameItemSameComponents((ItemStack)testStack, (ItemStack)referenceStack2));
    }

    private boolean scanInventory(Container inv, ItemStack mainHandStack, ItemStack offHandStack) {
        for (int l = 0; l < inv.getContainerSize(); ++l) {
            ItemStack inventoryStack = inv.getItem(l);
            if (inventoryStack == null || !this.equalStacks(inventoryStack, mainHandStack, offHandStack)) continue;
            return true;
        }
        return false;
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean armor = !living.getItemBySlot(EquipmentSlot.HEAD).isEmpty();
            bipedModel.head.translateAndRotate(ms);
            ms.translate(-0.35, -0.2, armor ? 0.05 : 0.1);
            ms.scale(0.75f, -0.75f, -0.75f);
            BakedModel model = MiscellaneousModels.INSTANCE.itemFinderGem;
            VertexConsumer buffer = buffers.getBuffer(Sheets.cutoutBlockSheet());
            Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(ms.last(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
        }
    }
}

