/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.helper.AccessoryRenderHelper;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.item.equipment.bauble.CirrusAmuletItem;
import vazkii.botania.common.proxy.Proxy;

public class SojournersSashItem
extends BaubleItem {
    private static final UUID STEP_BOOST_UUID = UUID.fromString("8511cd62-2650-4078-8d69-9ebe80b21eb5");
    private static final AttributeModifier STEP_BOOST = new AttributeModifier(BotaniaAPI.botaniaRL("travel_belt"), 0.65, AttributeModifier.Operation.ADD_VALUE);
    private static final ResourceLocation texture = ResourceLocation.parse((String)"botania:textures/model/belt_travel.png");
    private static final int COST = 1;
    private static final int COST_INTERVAL = 10;
    public final float speed;
    public final float jump;
    public final float fallBuffer;

    public SojournersSashItem(Item.Properties props) {
        this(props, 0.035f, 0.2f, 2.0f);
    }

    public static float onPlayerFall(Player entity, float dist) {
        boolean pendantJump = CirrusAmuletItem.popJumping(entity);
        ItemStack stack = EquipmentHandler.findOrEmpty(s -> s.getItem() instanceof SojournersSashItem, (LivingEntity)entity);
        if (!stack.isEmpty()) {
            ItemStack amulet;
            float fallBuffer = ((SojournersSashItem)stack.getItem()).fallBuffer;
            if (pendantJump && !(amulet = EquipmentHandler.findOrEmpty(s -> s.getItem() instanceof CirrusAmuletItem, (LivingEntity)entity)).isEmpty()) {
                fallBuffer *= (float)((CirrusAmuletItem)amulet.getItem()).getMaxAllowedJumps();
            }
            return Math.max(0.0f, dist - fallBuffer);
        }
        return dist;
    }

    public SojournersSashItem(Item.Properties props, float speed, float jump, float fallBuffer) {
        super(props);
        this.speed = speed;
        this.jump = jump;
        this.fallBuffer = fallBuffer;
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    public static void tickBelt(Player player) {
        ItemStack belt = EquipmentHandler.findOrEmpty(s -> s.getItem() instanceof SojournersSashItem, (LivingEntity)player);
        AttributeInstance attrib = player.getAttribute(Attributes.STEP_HEIGHT);
        boolean hasBoost = attrib.hasModifier(STEP_BOOST.id());
        if (SojournersSashItem.tryConsumeMana(player)) {
            if (player.level().isClientSide) {
                SojournersSashItem beltItem = (SojournersSashItem)belt.getItem();
                if ((player.onGround() || player.getAbilities().flying) && player.zza > 0.0f && !player.isInWaterOrBubble()) {
                    float speed = beltItem.getSpeed(belt);
                    player.moveRelative(player.getAbilities().flying ? speed : speed, new Vec3(0.0, 0.0, 1.0));
                    beltItem.onMovedTick(belt, player);
                    if (player.tickCount % 10 == 0) {
                        ManaItemHandler.instance().requestManaExact(belt, player, 1, true);
                    }
                } else {
                    beltItem.onNotMovingTick(belt, player);
                }
            } else if (player.isShiftKeyDown()) {
                if (hasBoost) {
                    attrib.removeModifier(STEP_BOOST);
                }
            } else if (!hasBoost) {
                attrib.addTransientModifier(STEP_BOOST);
            }
        } else if (!player.level().isClientSide && hasBoost) {
            attrib.removeModifier(STEP_BOOST);
        }
    }

    public float getSpeed(ItemStack stack) {
        return this.speed;
    }

    public void onMovedTick(ItemStack stack, Player player) {
    }

    public void onNotMovingTick(ItemStack stack, Player player) {
    }

    public static void onPlayerJump(LivingEntity living) {
        Player player;
        ItemStack belt;
        if (living instanceof Player && !(belt = EquipmentHandler.findOrEmpty(s -> s.getItem() instanceof SojournersSashItem, (LivingEntity)(player = (Player)living))).isEmpty() && ManaItemHandler.instance().requestManaExact(belt, player, 1, false)) {
            player.setDeltaMovement(player.getDeltaMovement().add(0.0, (double)((SojournersSashItem)belt.getItem()).jump, 0.0));
        }
    }

    private static boolean tryConsumeMana(Player player) {
        ItemStack result = EquipmentHandler.findOrEmpty(s -> s.getItem() instanceof SojournersSashItem, (LivingEntity)player);
        return !result.isEmpty() && ManaItemHandler.instance().requestManaExact(result, player, 1, false);
    }

    ResourceLocation getRenderTexture() {
        return texture;
    }

    public static class Renderer
    implements AccessoryRenderer {
        private static HumanoidModel<LivingEntity> model = null;

        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            AccessoryRenderHelper.rotateIfSneaking(ms, living);
            float s = 1.15f;
            ms.scale(s, s, s);
            if (model == null) {
                model = new HumanoidModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER));
            }
            ResourceLocation texture = ((SojournersSashItem)stack.getItem()).getRenderTexture();
            VertexConsumer buffer = buffers.getBuffer(model.renderType(texture));
            Renderer.model.body.render(ms, buffer, light, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)1, (int)1, (int)1, (int)1));
        }
    }
}

