/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.mixin.ItemEntityAccessor;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class RingOfMagnetizationItem
extends BaubleItem {
    public static final int DEFAULT_RANGE = 6;
    public static final int DEFAULT_GREATER_RANGE = 16;

    public RingOfMagnetizationItem(Item.Properties props) {
        super(props);
    }

    public static void onTossItem(Player player) {
        ItemStack ring = EquipmentHandler.findOrEmpty(s -> s.getItem() instanceof RingOfMagnetizationItem, (LivingEntity)player);
        if (!ring.isEmpty()) {
            player.getCooldowns().addCooldown(ring.getItem(), 100);
        }
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        super.onWornTick(stack, living);
        if (living.isSpectator()) {
            return;
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            boolean isOnCooldown = player.getCooldowns().isOnCooldown((Item)this);
            if (BotaniaAPI.instance().hasSolegnoliaAround((Entity)living)) {
                if (!isOnCooldown) {
                    player.getCooldowns().addCooldown((Item)this, 2);
                }
                return;
            }
            if (!isOnCooldown && living.isShiftKeyDown() == BotaniaConfig.common().invertMagnetRing()) {
                double x = living.getX();
                double y = living.getY() + 0.5 * (double)living.getEyeHeight();
                double z = living.getZ();
                int range = (Integer)stack.getOrDefault(BotaniaDataComponents.RANGE, (Object)6);
                List items = living.level().getEntitiesOfClass(ItemEntity.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
                int pulled = 0;
                for (ItemEntity item : items) {
                    if (!RingOfMagnetizationItem.canPullItem(item)) continue;
                    if (pulled > 200) break;
                    MathHelper.setEntityMotionFromVector((Entity)item, new Vec3(x, y, z), 0.45f);
                    if (living.level().isClientSide) {
                        boolean red = living.level().random.nextBoolean();
                        float r = red ? 1.0f : 0.0f;
                        float b = red ? 0.0f : 1.0f;
                        SparkleParticleData data = SparkleParticleData.sparkle(1.0f, r, 0.0f, b, 3);
                        living.level().addParticle((ParticleOptions)data, item.getX(), item.getY(), item.getZ(), 0.0, 0.0, 0.0);
                    }
                    ++pulled;
                }
            }
        }
    }

    private static boolean canPullItem(ItemEntity item) {
        int pickupDelay = ((ItemEntityAccessor)item).getPickupDelay();
        if (!item.isAlive() || pickupDelay >= 40 || BotaniaAPI.instance().hasSolegnoliaAround((Entity)item) || XplatAbstractions.INSTANCE.preventsRemoteMovement(item)) {
            return false;
        }
        ItemStack stack = item.getItem();
        if (stack.isEmpty() || XplatAbstractions.INSTANCE.findManaItem(stack) != null || XplatAbstractions.INSTANCE.findRelic(stack) != null || stack.is(BotaniaTags.Items.MAGNET_RING_BLACKLIST)) {
            return false;
        }
        BlockPos pos = item.blockPosition();
        if (item.level().getBlockState(pos).is(BotaniaTags.Blocks.MAGNET_RING_BLACKLIST)) {
            return false;
        }
        return !item.level().getBlockState(pos.below()).is(BotaniaTags.Blocks.MAGNET_RING_BLACKLIST);
    }
}

