/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;

public class RingOfChordataItem
extends BaubleItem {
    private static final int COST = 3;

    public RingOfChordataItem(Item.Properties props) {
        super(props);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        if (!living.isInWaterOrBubble()) {
            this.onUnequipped(stack, living);
            return;
        }
        ItemStack result = EquipmentHandler.findOrEmpty(BotaniaItems.waterRing, living);
        if (result != stack) {
            return;
        }
        if (living.level().isClientSide) return;
        if (living instanceof Player) {
            Player player = (Player)living;
            if (!ManaItemHandler.instance().requestManaExact(stack, player, 3, true)) {
                this.onUnequipped(stack, living);
                return;
            }
        }
        RingOfChordataItem.addEffect(living, (Holder<MobEffect>)MobEffects.CONDUIT_POWER);
        RingOfChordataItem.addEffect(living, (Holder<MobEffect>)MobEffects.DOLPHINS_GRACE);
    }

    private static void addEffect(LivingEntity living, Holder<MobEffect> effect) {
        MobEffectInstance inst = living.getEffect(effect);
        if (inst == null || inst.getAmplifier() == 0 && inst.getDuration() == 1) {
            MobEffectInstance neweffect = new MobEffectInstance(effect, 100, 0, true, true);
            living.addEffect(neweffect);
        }
    }
}

