/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.item.CosmeticAttachable;
import vazkii.botania.api.item.CosmeticBauble;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.proxy.Proxy;

public class ManaseerMonocleItem
extends BaubleItem
implements CosmeticBauble {
    public ManaseerMonocleItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add((Component)Component.translatable((String)"botaniamisc.cosmeticBauble").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        super.appendHoverText(stack, context, tooltip, flags);
    }

    public static boolean hasMonocle(LivingEntity living) {
        return !EquipmentHandler.findOrEmpty(stack -> {
            if (!stack.isEmpty()) {
                Item item = stack.getItem();
                if (stack.is(BotaniaTags.Items.BURST_VIEWERS)) {
                    return true;
                }
                if (item instanceof CosmeticAttachable) {
                    CosmeticAttachable attach = (CosmeticAttachable)item;
                    ItemStack cosmetic = attach.getCosmeticItem((ItemStack)stack);
                    return !cosmetic.isEmpty() && cosmetic.is(BotaniaTags.Items.BURST_VIEWERS);
                }
            }
            return false;
        }, living).isEmpty();
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            bipedModel.head.translateAndRotate(ms);
            ms.translate(0.15, -0.2, -0.25);
            ms.scale(0.3f, -0.3f, -0.3f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, light, OverlayTexture.NO_OVERLAY, ms, buffers, living.level(), living.getId());
        }
    }

    public static class Hud {
        public static void render(GuiGraphics gui, Player player) {
            Minecraft mc = Minecraft.getInstance();
            HitResult ray = mc.hitResult;
            if (ray == null || ray.getType() != HitResult.Type.BLOCK) {
                return;
            }
            BlockPos pos = ((BlockHitResult)ray).getBlockPos();
            BlockState state = player.level().getBlockState(pos);
            player.level().getBlockEntity(pos);
            ItemStack dispStack = ItemStack.EMPTY;
            Object text = "";
            if (state.is(Blocks.REDSTONE_WIRE)) {
                dispStack = new ItemStack((ItemLike)Items.REDSTONE);
                text = String.valueOf(ChatFormatting.RED) + String.valueOf(state.getValue((Property)RedStoneWireBlock.POWER));
            } else if (state.is(Blocks.REPEATER)) {
                dispStack = new ItemStack((ItemLike)Blocks.REPEATER);
                text = String.valueOf(state.getValue((Property)RepeaterBlock.DELAY));
            } else if (state.is(Blocks.COMPARATOR)) {
                dispStack = new ItemStack((ItemLike)Blocks.COMPARATOR);
                Object object = text = state.getValue((Property)ComparatorBlock.MODE) == ComparatorMode.SUBTRACT ? "-" : "+";
            }
            if (dispStack.isEmpty()) {
                return;
            }
            int x = mc.getWindow().getGuiScaledWidth() / 2 + 15;
            int y = mc.getWindow().getGuiScaledHeight() / 2 - 8;
            gui.renderItem(dispStack, x, y);
            gui.drawString(mc.font, (String)text, x + 20, y + 4, 0xFFFFFF);
        }
    }
}

