/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableFloat;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.equipment.bauble.CloakOfVirtueItem;

public class CloakOfSinItem
extends CloakOfVirtueItem {
    private static final ResourceLocation texture = ResourceLocation.parse((String)"botania:textures/model/cloak_unholy.png");
    private static final ResourceLocation textureGlow = ResourceLocation.parse((String)"botania:textures/model/cloak_unholy_glow.png");

    public CloakOfSinItem(Item.Properties props) {
        super(props);
    }

    @Override
    protected boolean effectOnDamage(DamageSource src, MutableFloat amount, Player player, ItemStack stack) {
        if (!src.is(DamageTypeTags.BYPASSES_ARMOR)) {
            int range = 6;
            List mobs = player.level().getEntitiesOfClass(Entity.class, new AABB(player.getX() - (double)range, player.getY() - (double)range, player.getZ() - (double)range, player.getX() + (double)range, player.getY() + (double)range, player.getZ() + (double)range), (Predicate)Predicates.instanceOf(Enemy.class));
            for (Enemy mob : mobs) {
                if (!(mob instanceof LivingEntity)) continue;
                LivingEntity entity = (LivingEntity)mob;
                entity.hurt(player.damageSources().playerAttack(player), amount.getValue().floatValue());
            }
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.unholyCloak, SoundSource.PLAYERS, 1.0f, 1.0f);
            for (int i = 0; i < 90; ++i) {
                float rad = (float)i * 4.0f * (float)Math.PI / 180.0f;
                float xMotion = (float)Math.cos(rad) * 0.2f;
                float zMotion = (float)Math.sin(rad) * 0.2f;
                WispParticleData data = WispParticleData.wisp(0.6f + (float)Math.random() * 0.2f, 0.4f + (float)Math.random() + 0.25f, 0.0f, 0.0f);
                player.level().addParticle((ParticleOptions)data, player.getX(), player.getY() + 0.5, player.getZ(), (double)xMotion, 0.0, (double)zMotion);
            }
            return true;
        }
        return false;
    }

    @Override
    ResourceLocation getCloakTexture() {
        return texture;
    }

    @Override
    ResourceLocation getCloakGlowTexture() {
        return textureGlow;
    }
}

