/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableFloat;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.equipment.bauble.CloakOfVirtueItem;

public class CloakOfBalanceItem
extends CloakOfVirtueItem {
    private static final ResourceLocation texture = ResourceLocation.parse((String)"botania:textures/model/cloak_balance.png");
    private static final ResourceLocation textureGlow = ResourceLocation.parse((String)"botania:textures/model/cloak_balance_glow.png");

    public CloakOfBalanceItem(Item.Properties props) {
        super(props);
    }

    @Override
    protected boolean effectOnDamage(DamageSource src, MutableFloat amount, Player player, ItemStack stack) {
        if (!src.is(DamageTypeTags.WITCH_RESISTANT_TO)) {
            amount.setValue(amount.getValue().floatValue() / 2.0f);
            if (src.getEntity() != null) {
                src.getEntity().hurt(player.damageSources().indirectMagic((Entity)player, (Entity)player), amount.getValue().floatValue());
            }
            if (amount.getValue().floatValue() > player.getHealth()) {
                amount.setValue(player.getHealth() - 1.0f);
            }
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.holyCloak, SoundSource.PLAYERS, 1.0f, 1.0f);
            for (int i = 0; i < 30; ++i) {
                double x = player.getX() + Math.random() * (double)player.getBbWidth() * 2.0 - (double)player.getBbWidth();
                double y = player.getY() + Math.random() * (double)player.getBbHeight();
                double z = player.getZ() + Math.random() * (double)player.getBbWidth() * 2.0 - (double)player.getBbWidth();
                boolean green = Math.random() > 0.5;
                float g = green ? 1.0f : 0.3f;
                float b = green ? 0.3f : 1.0f;
                SparkleParticleData data = SparkleParticleData.sparkle(0.8f + (float)Math.random() * 0.4f, 0.3f, g, b, 3);
                player.level().addParticle((ParticleOptions)data, x, y, z, 0.0, 0.0, 0.0);
            }
            return true;
        }
        return false;
    }

    @Override
    ResourceLocation getCloakTexture() {
        return texture;
    }

    @Override
    ResourceLocation getCloakGlowTexture() {
        return textureGlow;
    }
}

