/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Position;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.block.flower.functional.HeiseiDreamBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.mixin.CreeperAccessor;
import vazkii.botania.mixin.EntityAccessor;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class CharmOfTheDivaItem
extends BaubleItem {
    public static final int MANA_COST = 250;
    public static final int CHARM_RANGE = 20;

    public CharmOfTheDivaItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    private static Predicate<Mob> getCharmTargetPredicate(Player player, Mob mobToCharm) {
        return mob -> {
            TamableAnimal targetTamable;
            LivingEntity patt0$temp;
            NeutralMob neutralMob;
            TamableAnimal tamable;
            return mob != mobToCharm && mob.isAlive() && mob.canBeSeenAsEnemy() && !mob.isPassengerOfSameVehicle((Entity)mobToCharm) && (!(mob instanceof TamableAnimal) || !(tamable = (TamableAnimal)mob).isOwnedBy((LivingEntity)player)) && (mob instanceof Enemy || mob instanceof NeutralMob && ((neutralMob = (NeutralMob)mob).isAngryAt((LivingEntity)player) || (patt0$temp = mob.getTarget()) instanceof TamableAnimal && (targetTamable = (TamableAnimal)patt0$temp).isOwnedBy((LivingEntity)player)));
        };
    }

    private static void charmMobs(ItemStack amulet, Player player, Mob target) {
        List potentialTargets;
        TamableAnimal tamable;
        if (!ManaItemHandler.instance().requestManaExact(amulet, player, 250, false)) {
            return;
        }
        if (target.isAlive() && (target instanceof Enemy || target instanceof NeutralMob) && (!(target instanceof TamableAnimal) || !(tamable = (TamableAnimal)target).isOwnedBy((LivingEntity)player)) && player.position().closerThan((Position)target.position(), 20.0) && !(potentialTargets = player.level().getEntitiesOfClass(Mob.class, AABB.ofSize((Vec3)target.position(), (double)40.0, (double)40.0, (double)40.0), CharmOfTheDivaItem.getCharmTargetPredicate(player, target))).isEmpty() && HeiseiDreamBlockEntity.brainwashEntity(target, potentialTargets)) {
            target.heal(target.getMaxHealth());
            ((EntityAccessor)target).callUnsetRemoved();
            if (target instanceof Creeper) {
                ((CreeperAccessor)target).setCurrentFuseTime(2);
            }
            ManaItemHandler.instance().requestManaExact(amulet, player, 250, true);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.divaCharm, SoundSource.PLAYERS, 1.0f, 1.0f);
            XplatAbstractions.INSTANCE.sendToTracking((Entity)target, new BotaniaEffectPacket(EffectType.DIVA_EFFECT, target.getX(), target.getY(), target.getZ(), target.getId()));
        }
    }

    public static void onEntityDamaged(Player player, LivingEntity entity) {
        if (entity instanceof Mob) {
            Mob target = (Mob)entity;
            if (!target.level().isClientSide && Math.random() < 0.6) {
                MinecraftServer server = player.level().getServer();
                ItemStack amulet = EquipmentHandler.findOrEmpty(BotaniaItems.divaCharm, (LivingEntity)player);
                if (server != null && !amulet.isEmpty()) {
                    server.tell((Runnable)new TickTask(0, () -> CharmOfTheDivaItem.charmMobs(amulet, player, target)));
                }
            }
        }
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            bipedModel.head.translateAndRotate(ms);
            ms.translate(0.15, -0.42, -0.35);
            ms.scale(0.4f, -0.4f, -0.4f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, light, OverlayTexture.NO_OVERLAY, ms, buffers, living.level(), living.getId());
        }
    }
}

