/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.CosmeticAttachable;
import vazkii.botania.api.item.PhantomInkable;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.DataComponentHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.xplat.BotaniaConfig;

public abstract class BaubleItem
extends Item
implements CosmeticAttachable,
PhantomInkable {
    private static final String TAG_BAUBLE_UUID = "baubleUUID";
    private static final String TAG_COSMETIC_ITEM = "cosmeticItem";
    private static final String TAG_PHANTOM_INK = "phantomInk";

    public BaubleItem(Item.Properties props) {
        super(props);
        EquipmentHandler.instance.onInit(this);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        ItemStack cosmetic = this.getCosmeticItem(stack);
        if (!cosmetic.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"botaniamisc.hasCosmetic", (Object[])new Object[]{cosmetic.getHoverName()}).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        if (this.hasPhantomInk(stack)) {
            tooltip.add((Component)Component.translatable((String)"botaniamisc.hasPhantomInk").withStyle(ChatFormatting.AQUA));
        }
    }

    @Override
    public ItemStack getCosmeticItem(ItemStack stack) {
        return stack;
    }

    @Override
    public void setCosmeticItem(ItemStack stack, ItemStack cosmetic) {
    }

    public static UUID getBaubleUUID(ItemStack stack) {
        return UUID.fromString("0e5420ba-bbba-4155-9d22-8894d78b9cc7");
    }

    @Override
    public boolean hasPhantomInk(ItemStack stack) {
        return stack.has(BotaniaDataComponents.PHANTOM_INKED);
    }

    @Override
    public void setPhantomInk(ItemStack stack, boolean ink) {
        DataComponentHelper.setFlag(stack, BotaniaDataComponents.PHANTOM_INKED, ink);
    }

    public void onWornTick(ItemStack stack, LivingEntity entity) {
    }

    public void onEquipped(ItemStack stack, LivingEntity entity) {
        if (!entity.level().isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerHelper.grantCriterion(player, BotaniaAPI.botaniaRL("main/bauble_wear"), "code_triggered");
        }
    }

    public void onUnequipped(ItemStack stack, LivingEntity entity) {
    }

    public boolean canEquip(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getEquippedAttributeModifiers(ItemStack stack) {
        return HashMultimap.create();
    }

    public boolean hasRender(ItemStack stack, LivingEntity living) {
        return !this.hasPhantomInk(stack) && BotaniaConfig.client().renderAccessories() && !living.isInvisible();
    }
}

