/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.elementium;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ManasteelArmorItem;

public abstract class ElementiumArmorItem
extends ManasteelArmorItem {
    private static final Supplier<ItemStack[]> armorSet = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)BotaniaItems.elementiumHelm), new ItemStack((ItemLike)BotaniaItems.elementiumChest), new ItemStack((ItemLike)BotaniaItems.elementiumLegs), new ItemStack((ItemLike)BotaniaItems.elementiumBoots)});

    public ElementiumArmorItem(ArmorItem.Type type, Item.Properties props) {
        super(type, BotaniaAPI.instance().getElementiumArmorMaterial(), props);
    }

    @Override
    public ResourceLocation getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return BotaniaAPI.botaniaRL("botania:textures/model/armor_elementium.png");
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return armorSet.get();
    }

    @Override
    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.getItemBySlot(slot);
        if (stack.isEmpty()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> stack.is(BotaniaItems.elementiumHelm);
            case EquipmentSlot.CHEST -> stack.is(BotaniaItems.elementiumChest);
            case EquipmentSlot.LEGS -> stack.is(BotaniaItems.elementiumLegs);
            case EquipmentSlot.FEET -> stack.is(BotaniaItems.elementiumBoots);
            default -> false;
        };
    }

    @Override
    public MutableComponent getArmorSetName() {
        return Component.translatable((String)"botania.armorset.elementium.name");
    }

    @Override
    public void addArmorSetDescription(ItemStack stack, List<Component> list) {
        super.addArmorSetDescription(stack, list);
        list.add((Component)Component.translatable((String)"botania.armorset.elementium.desc").withStyle(ChatFormatting.GRAY));
    }
}

