/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.brew;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewContainer;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.helper.DataComponentHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;

public class IncenseStickItem
extends Item
implements BrewItem,
BrewContainer,
CustomCreativeTabContents {
    public static final int TIME_MULTIPLIER = 60;

    public IncenseStickItem(Item.Properties builder) {
        super(builder);
    }

    @Override
    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        output.accept((ItemLike)this);
        for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
            ItemStack brewStack = this.getItemForBrew(brew, new ItemStack((ItemLike)this));
            if (brewStack.isEmpty()) continue;
            output.accept(brewStack);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flags) {
        Brew brew = this.getBrew(stack);
        if (brew == BotaniaBrews.fallbackBrew) {
            list.add((Component)Component.translatable((String)"botaniamisc.notInfused").withStyle(ChatFormatting.LIGHT_PURPLE));
            return;
        }
        list.add((Component)Component.translatable((String)"botaniamisc.brewOf", (Object[])new Object[]{Component.translatable((String)brew.getTranslationKey(stack))}).withStyle(ChatFormatting.LIGHT_PURPLE));
        PotionContents.addPotionTooltip(brew.getPotionEffects(stack), list::add, (float)60.0f, (float)context.tickRate());
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        ResourceLocation id = (ResourceLocation)stack.get(BotaniaDataComponents.BREW);
        return Objects.requireNonNull((Brew)BotaniaAPI.instance().getBrewRegistry().get(id));
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        IncenseStickItem.setBrew(stack, Objects.requireNonNull(BotaniaAPI.instance().getBrewRegistry().getKey((Object)brew)));
    }

    public static void setBrew(ItemStack stack, ResourceLocation brew) {
        DataComponentHelper.setOptional(stack, BotaniaDataComponents.BREW, brew);
    }

    @Override
    public ItemStack getItemForBrew(Brew brew, ItemStack stack) {
        if (!brew.canInfuseIncense() || brew.getPotionEffects(stack).size() != 1 || ((MobEffect)brew.getPotionEffects(stack).getFirst().getEffect().value()).isInstantenous()) {
            return ItemStack.EMPTY;
        }
        ItemStack brewStack = new ItemStack((ItemLike)this);
        IncenseStickItem.setBrew(brewStack, brew);
        return brewStack;
    }

    @Override
    public int getManaCost(Brew brew, ItemStack stack) {
        return brew.getManaCost() * 10;
    }
}

