/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.brew;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.helper.DataComponentHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;

public class BaseBrewItem
extends Item
implements BrewItem,
CustomCreativeTabContents {
    public static final int DEFAULT_USES_VIAL = 4;
    public static final int DEFAULT_USES_FLASK = 6;
    private final int drinkSpeed;
    private final Supplier<Item> baseItem;

    public BaseBrewItem(Item.Properties builder, int drinkSpeed, Supplier<Item> baseItem) {
        super(builder);
        this.drinkSpeed = drinkSpeed;
        this.baseItem = baseItem;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.drinkSpeed;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, Level world, LivingEntity living) {
        if (!world.isClientSide) {
            for (MobEffectInstance effect : this.getBrew(stack).getPotionEffects(stack)) {
                MobEffectInstance newEffect = new MobEffectInstance(effect.getEffect(), effect.getDuration(), effect.getAmplifier(), true, true);
                if (((MobEffect)effect.getEffect().value()).isInstantenous()) {
                    ((MobEffect)effect.getEffect().value()).applyInstantenousEffect((Entity)living, (Entity)living, living, newEffect.getAmplifier(), 1.0);
                    continue;
                }
                living.addEffect(newEffect);
            }
            if (world.random.nextBoolean()) {
                world.playSound(null, living.getX(), living.getY(), living.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            int swigs = this.getSwigsLeft(stack);
            if (living instanceof Player) {
                Player player = (Player)living;
                if (!player.getAbilities().instabuild) {
                    if (swigs <= 1) {
                        ItemStack result = this.getBaseStack();
                        if (!player.getInventory().add(result)) {
                            return result;
                        }
                        return ItemStack.EMPTY;
                    }
                    this.setSwigsLeft(stack, swigs - 1);
                }
            }
        }
        return stack;
    }

    @Override
    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
            if (brew == BotaniaBrews.fallbackBrew) continue;
            ItemStack stack = new ItemStack((ItemLike)this);
            BaseBrewItem.setBrew(stack, brew);
            output.accept(stack);
        }
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{Component.translatable((String)this.getBrew(stack).getTranslationKey(stack)), Component.literal((String)Integer.toString(this.getSwigsLeft(stack))).withStyle(ChatFormatting.BOLD)});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flags) {
        PotionContents.addPotionTooltip(this.getBrew(stack).getPotionEffects(stack), list::add, (float)1.0f, (float)context.tickRate());
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        ResourceLocation id = (ResourceLocation)stack.get(BotaniaDataComponents.BREW);
        return (Brew)BotaniaAPI.instance().getBrewRegistry().get(id);
    }

    public static void setBrew(ItemStack stack, @Nullable Brew brew) {
        ResourceLocation id = brew != null ? BotaniaAPI.instance().getBrewRegistry().getKey((Object)brew) : BotaniaAPI.botaniaRL("fallback");
        BaseBrewItem.setBrew(stack, id);
    }

    public static void setBrew(ItemStack stack, @Nullable ResourceLocation brew) {
        DataComponentHelper.setOptional(stack, BotaniaDataComponents.BREW, brew);
    }

    @NotNull
    public static String getSubtype(ItemStack stack) {
        return Optional.ofNullable((ResourceLocation)stack.get(BotaniaDataComponents.BREW)).map(ResourceLocation::toString).orElse("none");
    }

    public int getSwigs(ItemStack stack) {
        return (Integer)stack.getOrDefault(BotaniaDataComponents.MAX_USES, (Object)1);
    }

    public int getSwigsLeft(ItemStack stack) {
        return (Integer)stack.getOrDefault(BotaniaDataComponents.REMAINING_USES, (Object)this.getSwigs(stack));
    }

    public void setSwigsLeft(ItemStack stack, int swigs) {
        stack.set(BotaniaDataComponents.REMAINING_USES, (Object)swigs);
    }

    public ItemStack getBaseStack() {
        return new ItemStack((ItemLike)this.baseItem.get());
    }
}

