/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.Bound;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.ForceRelayBlock;
import vazkii.botania.common.block.block_entity.ManaEnchanterBlockEntity;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.DataComponentHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class WandOfTheForestItem
extends Item
implements CustomCreativeTabContents {
    public final ChatFormatting modeChatFormatting;

    public WandOfTheForestItem(ChatFormatting formatting, Item.Properties builder) {
        super(builder);
        this.modeChatFormatting = formatting;
    }

    private static boolean tryCompleteBinding(GlobalPos src, ItemStack stack, UseOnContext ctx) {
        BlockPos dest = ctx.getClickedPos();
        if (!dest.equals((Object)src.pos()) && src.dimension().equals(ctx.getLevel().dimension())) {
            WandOfTheForestItem.setBindingAttempt(stack, null);
            BlockEntity srcTile = ctx.getLevel().getBlockEntity(src.pos());
            if (srcTile instanceof WandBindable) {
                WandBindable bindable = (WandBindable)srcTile;
                if (bindable.bindTo(ctx.getPlayer(), stack, dest, ctx.getClickedFace())) {
                    WandOfTheForestItem.doParticleBeamWithOffset(ctx.getLevel(), src.pos(), dest);
                    WandOfTheForestItem.setBindingAttempt(stack, null);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean tryFormEnchanter(UseOnContext ctx) {
        BlockPos pos;
        Level world = ctx.getLevel();
        Direction.Axis axis = ManaEnchanterBlockEntity.canEnchanterExist(world, pos = ctx.getClickedPos());
        if (axis != null) {
            if (!world.isClientSide) {
                world.setBlockAndUpdate(pos, (BlockState)BotaniaBlocks.enchanter.defaultBlockState().setValue(BotaniaStateProperties.ENCHANTER_DIRECTION, (Comparable)axis));
                world.playSound(null, pos, BotaniaSounds.enchanterForm, SoundSource.BLOCKS, 1.0f, 1.0f);
                PlayerHelper.grantCriterion((ServerPlayer)ctx.getPlayer(), BotaniaAPI.botaniaRL("main/enchanter_make"), "code_triggered");
            } else {
                for (int i = 0; i < 50; ++i) {
                    float red = (float)Math.random();
                    float green = (float)Math.random();
                    float blue = (float)Math.random();
                    double x = (Math.random() - 0.5) * 6.0;
                    double y = (Math.random() - 0.5) * 6.0;
                    double z = (Math.random() - 0.5) * 6.0;
                    float velMul = 0.07f;
                    float motionx = (float)(-x) * velMul;
                    float motiony = (float)(-y) * velMul;
                    float motionz = (float)(-z) * velMul;
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, red, green, blue);
                    world.addParticle((ParticleOptions)data, (double)pos.getX() + 0.5 + x, (double)pos.getY() + 0.5 + y, (double)pos.getZ() + 0.5 + z, (double)motionx, (double)motiony, (double)motionz);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean tryCompletePistonRelayBinding(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        GlobalPos bindPos = ((ForceRelayBlock)BotaniaBlocks.pistonRelay).activeBindingAttempts.get(player.getUUID());
        if (bindPos != null && bindPos.dimension() == world.dimension()) {
            ((ForceRelayBlock)BotaniaBlocks.pistonRelay).activeBindingAttempts.remove(player.getUUID());
            ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get(world);
            data.mapping.put(bindPos.pos(), pos.immutable());
            data.setDirty();
            XplatAbstractions.INSTANCE.sendToNear(world, pos, new BotaniaEffectPacket(EffectType.PARTICLE_BEAM, (double)bindPos.pos().getX() + 0.5, (double)bindPos.pos().getY() + 0.5, (double)bindPos.pos().getZ() + 0.5, pos.getX(), pos.getY(), pos.getZ()));
            world.playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.ding, SoundSource.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Wandable wandable;
        ItemStack stack = ctx.getItemInHand();
        Level world = ctx.getLevel();
        Player player = ctx.getPlayer();
        BlockPos pos = ctx.getClickedPos();
        GlobalPos globalPos = GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos);
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        Direction side = ctx.getClickedFace();
        Optional<GlobalPos> boundPos = WandOfTheForestItem.getBindingAttempt(stack);
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.isSecondaryUseActive()) {
            BlockState newState;
            if (boundPos.filter(loc -> WandOfTheForestItem.tryCompleteBinding(loc, stack, ctx)).isPresent()) {
                return InteractionResult.SUCCESS;
            }
            if (player.mayUseItemAt(pos, side, stack) && (!(block instanceof CommandBlock) || player.canUseGameMasterBlocks()) && (newState = WandOfTheForestItem.manipulateBlockstate(state, side, blockState -> blockState.canSurvive((LevelReader)world, pos))) != state) {
                world.setBlockAndUpdate(pos, newState);
                ctx.getLevel().playSound(ctx.getPlayer(), ctx.getClickedPos(), newState.getBlock().asItem().getBreakingSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        if (state.is(Blocks.LAPIS_BLOCK) && BotaniaConfig.common().enchanterEnabled() && WandOfTheForestItem.tryFormEnchanter(ctx)) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = world.getBlockEntity(pos);
        if (WandOfTheForestItem.getBindMode(stack) && tile instanceof WandBindable) {
            WandBindable bindable = (WandBindable)tile;
            if (player.isShiftKeyDown() && bindable.canSelect(player, stack, pos, side)) {
                if (boundPos.filter(arg_0 -> ((GlobalPos)globalPos).equals(arg_0)).isPresent()) {
                    WandOfTheForestItem.setBindingAttempt(stack, null);
                } else {
                    WandOfTheForestItem.setBindingAttempt(stack, globalPos);
                }
                if (world.isClientSide) {
                    player.playSound(BotaniaSounds.ding, 0.11f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if ((wandable = XplatAbstractions.INSTANCE.findWandable(world, pos, state, tile)) != null) {
            return wandable.onUsedByWand(player, stack, side) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        if (!world.isClientSide && WandOfTheForestItem.getBindMode(stack) && WandOfTheForestItem.tryCompletePistonRelayBinding(ctx)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static BlockState manipulateBlockstate(BlockState oldState, Direction side, Predicate<BlockState> canSurvive) {
        Optional<Property> facingPropOptional;
        if (oldState.is(BotaniaTags.Blocks.UNWANDABLE)) {
            return oldState;
        }
        if (oldState.getBlock() instanceof RotatedPillarBlock) {
            return WandOfTheForestItem.iterateToNextValidPropertyValue(oldState, BlockStateProperties.AXIS, BlockStateProperties.AXIS.getPossibleValues(), (Direction.Axis)oldState.getValue((Property)BlockStateProperties.AXIS), canSurvive);
        }
        if (oldState.hasProperty((Property)BlockStateProperties.ROTATION_16)) {
            return WandOfTheForestItem.iterateToNextValidPropertyValue(oldState, BlockStateProperties.ROTATION_16, BlockStateProperties.ROTATION_16.getPossibleValues(), (Integer)oldState.getValue((Property)BlockStateProperties.ROTATION_16), canSurvive);
        }
        BooleanProperty directionPropertyFromSide = (BooleanProperty)PipeBlock.PROPERTY_BY_DIRECTION.get(side);
        if (oldState.hasProperty((Property)directionPropertyFromSide) && oldState.getProperties().containsAll(PipeBlock.PROPERTY_BY_DIRECTION.values())) {
            boolean oldValue = (Boolean)oldState.getValue((Property)directionPropertyFromSide);
            BlockState newState = (BlockState)oldState.setValue((Property)directionPropertyFromSide, (Comparable)Boolean.valueOf(!oldValue));
            return canSurvive.test(newState) ? newState : oldState;
        }
        if (side.getAxis() != Direction.Axis.Y) {
            if (oldState.getBlock() instanceof SlabBlock) {
                switch ((SlabType)oldState.getValue((Property)BlockStateProperties.SLAB_TYPE)) {
                    case TOP: {
                        return (BlockState)oldState.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.BOTTOM);
                    }
                    case BOTTOM: {
                        return (BlockState)oldState.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP);
                    }
                }
            } else if (oldState.hasProperty((Property)BlockStateProperties.HALF)) {
                BlockState newState = (BlockState)oldState.cycle((Property)BlockStateProperties.HALF);
                return canSurvive.test(newState) ? newState : oldState;
            }
        }
        if ((facingPropOptional = oldState.getProperties().stream().filter(prop -> prop.getName().equals("facing") && prop.getValueClass() == Direction.class).findFirst()).isPresent()) {
            Property facingProp = facingPropOptional.get();
            return WandOfTheForestItem.rotateFacingDirection(oldState, side, canSurvive, (Property<Direction>)facingProp);
        }
        for (Rotation rot : new Rotation[]{Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_180, Rotation.COUNTERCLOCKWISE_90}) {
            BlockState newState = oldState.rotate(rot);
            if (!canSurvive.test(newState)) continue;
            return newState;
        }
        return oldState;
    }

    private static BlockState rotateFacingDirection(BlockState oldState, Direction side, Predicate<BlockState> canSurvive, Property<Direction> facingProp) {
        if (oldState.hasProperty((Property)BlockStateProperties.CHEST_TYPE) && !((ChestType)oldState.getValue((Property)BlockStateProperties.CHEST_TYPE)).equals((Object)ChestType.SINGLE) || oldState.hasProperty((Property)BlockStateProperties.EXTENDED) && ((Boolean)oldState.getValue((Property)BlockStateProperties.EXTENDED)).equals(Boolean.TRUE) || oldState.hasProperty((Property)BlockStateProperties.BED_PART)) {
            return oldState;
        }
        Direction oldDir = (Direction)oldState.getValue(facingProp);
        if (oldState.hasProperty((Property)BlockStateProperties.ATTACH_FACE) && oldState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            if (side.getAxis() == Direction.Axis.Y) {
                return WandOfTheForestItem.rotateClockwiseAroundSideDirect(oldState, side, canSurvive, facingProp, oldDir);
            }
            AttachFace attachFace = (AttachFace)oldState.getValue((Property)BlockStateProperties.ATTACH_FACE);
            if (attachFace == AttachFace.WALL && oldDir.getAxis() == side.getAxis()) {
                BlockState newState = (BlockState)oldState.setValue(facingProp, (Comparable)oldDir.getOpposite());
                return canSurvive.test(newState) ? newState : oldState;
            }
            Direction impliedDir = switch (attachFace) {
                default -> throw new MatchException(null, null);
                case AttachFace.FLOOR -> Direction.DOWN;
                case AttachFace.CEILING -> Direction.UP;
                case AttachFace.WALL -> oldDir;
            };
            Function<Direction, BlockState> newStateFunction = dir -> switch (dir) {
                case Direction.UP -> (BlockState)oldState.setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.CEILING);
                case Direction.DOWN -> (BlockState)oldState.setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.FLOOR);
                default -> (BlockState)((BlockState)oldState.setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.WALL)).setValue(facingProp, (Comparable)dir);
            };
            return WandOfTheForestItem.rotateClockwiseAroundSide(side, impliedDir, newStateFunction, canSurvive);
        }
        ArrayList possibleFacingValues = new ArrayList(BlockStateProperties.FACING.getPossibleValues());
        if (possibleFacingValues.retainAll(facingProp.getPossibleValues())) {
            if (possibleFacingValues.isEmpty()) {
                return oldState;
            }
            return WandOfTheForestItem.iterateToNextValidPropertyValue(oldState, facingProp, possibleFacingValues, oldDir, canSurvive);
        }
        if (oldDir.getAxis() != side.getAxis()) {
            return WandOfTheForestItem.rotateClockwiseAroundSideDirect(oldState, side, canSurvive, facingProp, oldDir);
        }
        BlockState newState = (BlockState)oldState.setValue(facingProp, (Comparable)oldDir.getOpposite());
        return canSurvive.test(newState) ? newState : oldState;
    }

    @NotNull
    private static BlockState rotateClockwiseAroundSideDirect(BlockState oldState, Direction side, Predicate<BlockState> canSurvive, Property<Direction> facingProp, Direction oldDir) {
        return WandOfTheForestItem.rotateClockwiseAroundSide(side, oldDir, dir -> (BlockState)oldState.setValue(facingProp, (Comparable)dir), canSurvive);
    }

    @NotNull
    private static BlockState rotateClockwiseAroundSide(Direction side, Direction oldDir, Function<Direction, BlockState> newStateFunction, Predicate<BlockState> canSurvive) {
        BlockState newState;
        Direction newDir = oldDir;
        do {
            newDir = WandOfTheForestItem.getClockwiseDirectionForSide(side, newDir);
            newState = newStateFunction.apply(newDir);
        } while (newDir != oldDir && !canSurvive.test(newState));
        return newState;
    }

    @NotNull
    private static Direction getClockwiseDirectionForSide(Direction side, Direction oldDir) {
        return side.getAxisDirection() == Direction.AxisDirection.NEGATIVE ? oldDir.getCounterClockWise(side.getAxis()) : oldDir.getClockWise(side.getAxis());
    }

    private static <T extends Comparable<T>> BlockState iterateToNextValidPropertyValue(BlockState oldState, Property<T> property, Collection<T> orderedValues, T oldValue, Predicate<BlockState> canSurvive) {
        Iterator<T> it = orderedValues.iterator();
        while (it.hasNext() && !((Comparable)it.next()).equals(oldValue)) {
        }
        while (it.hasNext()) {
            BlockState newState = (BlockState)oldState.setValue(property, (Comparable)it.next());
            if (!canSurvive.test(newState)) continue;
            return newState;
        }
        for (Comparable newValue : orderedValues) {
            if (newValue.equals(oldValue)) {
                return oldState;
            }
            BlockState newState = (BlockState)oldState.setValue(property, newValue);
            if (!canSurvive.test(newState)) continue;
            return newState;
        }
        return oldState;
    }

    public static void doParticleBeamWithOffset(Level world, BlockPos orig, BlockPos end) {
        Vec3 origOffset = world.getBlockState(orig).getOffset((BlockGetter)world, orig);
        Vec3 vorig = new Vec3((double)orig.getX() + origOffset.x() + 0.5, (double)orig.getY() + origOffset.y() + 0.5, (double)orig.getZ() + origOffset.z() + 0.5);
        Vec3 endOffset = world.getBlockState(end).getOffset((BlockGetter)world, end);
        Vec3 vend = new Vec3((double)end.getX() + endOffset.x() + 0.5, (double)end.getY() + endOffset.y() + 0.5, (double)end.getZ() + endOffset.z() + 0.5);
        WandOfTheForestItem.doParticleBeam(world, vorig, vend);
    }

    public static void doParticleBeam(Level world, Vec3 orig, Vec3 end) {
        if (!world.isClientSide) {
            return;
        }
        Vec3 diff = end.subtract(orig);
        Vec3 movement = diff.normalize().scale(0.05);
        int iters = (int)(diff.length() / movement.length());
        float huePer = 1.0f / (float)iters;
        float hueSum = (float)Math.random();
        Vec3 currentPos = orig;
        for (int i = 0; i < iters; ++i) {
            float hue = (float)i * huePer + hueSum;
            int color = Mth.hsvToRgb((float)Mth.frac((float)hue), (float)1.0f, (float)1.0f);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            SparkleParticleData data = SparkleParticleData.noClip(0.5f, r, g, b, 4);
            Proxy.INSTANCE.addParticleForceNear(world, data, currentPos.x, currentPos.y, currentPos.z, 0.0, 0.0, 0.0);
            currentPos = currentPos.add(movement);
        }
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        WandOfTheForestItem.getBindingAttempt(stack).ifPresent(pos -> {
            if (!pos.dimension().equals(world.dimension()) || !(world.getBlockEntity(pos.pos()) instanceof WandBindable)) {
                WandOfTheForestItem.setBindingAttempt(stack, null);
            }
        });
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isSecondaryUseActive()) {
            if (!world.isClientSide) {
                WandOfTheForestItem.setBindMode(stack, !WandOfTheForestItem.getBindMode(stack));
            } else {
                player.playSound(BotaniaSounds.ding, 0.1f, 1.0f);
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        output.accept((ItemLike)me);
        List<Pair> colorPairs = Arrays.asList(new Pair((Object)DyeColor.WHITE, (Object)DyeColor.LIGHT_BLUE), new Pair((Object)DyeColor.WHITE, (Object)DyeColor.PINK), new Pair((Object)DyeColor.LIGHT_BLUE, (Object)DyeColor.PINK), new Pair((Object)DyeColor.PURPLE, (Object)DyeColor.BLUE), new Pair((Object)DyeColor.RED, (Object)DyeColor.RED), new Pair((Object)DyeColor.BLUE, (Object)DyeColor.BLUE), new Pair((Object)DyeColor.ORANGE, (Object)DyeColor.ORANGE), new Pair((Object)DyeColor.BLACK, (Object)DyeColor.BLACK), new Pair((Object)DyeColor.GRAY, (Object)DyeColor.LIGHT_GRAY), new Pair((Object)DyeColor.PINK, (Object)DyeColor.PINK), new Pair((Object)DyeColor.YELLOW, (Object)DyeColor.LIME), new Pair((Object)DyeColor.WHITE, (Object)DyeColor.BLACK));
        Collections.shuffle(colorPairs);
        for (int i = 0; i < 7; ++i) {
            Pair pair = colorPairs.get(i);
            if (Math.random() < 0.5) {
                pair = new Pair((Object)((DyeColor)pair.getSecond()), (Object)((DyeColor)pair.getFirst()));
            }
            output.accept(WandOfTheForestItem.setColors(new ItemStack((ItemLike)me), (DyeColor)pair.getFirst(), (DyeColor)pair.getSecond()));
        }
    }

    public Component getName(ItemStack stack) {
        MutableComponent mode = Component.literal((String)" (").append((Component)Component.translatable((String)WandOfTheForestItem.getModeString(stack)).withStyle(this.modeChatFormatting)).append(")");
        return super.getName(stack).plainCopy().append((Component)mode);
    }

    public static ItemStack setColors(ItemStack wand, DyeColor color1, DyeColor color2) {
        wand.set(BotaniaDataComponents.WAND_COLOR1, (Object)color1);
        wand.set(BotaniaDataComponents.WAND_COLOR2, (Object)color2);
        return wand;
    }

    public static DyeColor getColor1(ItemStack stack) {
        return (DyeColor)stack.getOrDefault(BotaniaDataComponents.WAND_COLOR1, (Object)DyeColor.WHITE);
    }

    public static DyeColor getColor2(ItemStack stack) {
        return (DyeColor)stack.getOrDefault(BotaniaDataComponents.WAND_COLOR2, (Object)DyeColor.WHITE);
    }

    public static void setBindingAttempt(ItemStack stack, @Nullable GlobalPos pos) {
        DataComponentHelper.setOptional(stack, BotaniaDataComponents.BINDING_POS, pos);
    }

    public static Optional<GlobalPos> getBindingAttempt(ItemStack stack) {
        return Optional.ofNullable((GlobalPos)stack.get(BotaniaDataComponents.BINDING_POS));
    }

    public static boolean getBindMode(ItemStack stack) {
        return stack.has(BotaniaDataComponents.WAND_BIND_MODE);
    }

    public static void setBindMode(ItemStack stack, boolean bindMode) {
        DataComponentHelper.setFlag(stack, BotaniaDataComponents.WAND_BIND_MODE, bindMode);
    }

    public static String getModeString(ItemStack stack) {
        return "botaniamisc.wandMode." + (WandOfTheForestItem.getBindMode(stack) ? "bind" : "function");
    }

    public static class CoordBoundItemImpl
    implements CoordBoundItem {
        private final ItemStack stack;

        public CoordBoundItemImpl(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        @Nullable
        public BlockPos getBinding(Level world) {
            Optional<GlobalPos> bound = WandOfTheForestItem.getBindingAttempt(this.stack);
            if (bound.isPresent() && bound.get().dimension().equals(world.dimension())) {
                return bound.get().pos();
            }
            HitResult pos = ClientProxy.INSTANCE.getClientHit();
            if (pos instanceof BlockHitResult) {
                BlockEntity tile;
                BlockHitResult bHit = (BlockHitResult)pos;
                if (pos.getType() == HitResult.Type.BLOCK && (tile = world.getBlockEntity(bHit.getBlockPos())) instanceof Bound) {
                    Bound boundTile = (Bound)tile;
                    return boundTile.getBinding();
                }
            }
            return null;
        }
    }
}

