/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.VineBallEntity;
import vazkii.botania.common.handler.BotaniaSounds;

public class VineBallItem
extends Item
implements ProjectileItem {
    public VineBallItem(Item.Properties builder) {
        super(builder);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        if (!player.getAbilities().instabuild) {
            player.getItemInHand(hand).shrink(1);
        }
        world.playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.vineBallThrow, SoundSource.NEUTRAL, 1.0f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            VineBallEntity ball = new VineBallEntity((LivingEntity)player, true);
            ball.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            world.addFreshEntity((Entity)ball);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        return new VineBallEntity(pos.x(), pos.y(), pos.z(), level);
    }
}

