/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.DataComponentHelper;
import vazkii.botania.common.item.BotaniaItems;

public class StoneOfTemperanceItem
extends Item {
    public StoneOfTemperanceItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        this.toggleActive(stack, player, world);
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> stacks, TooltipFlag flags) {
        stacks.add((Component)Component.translatable((String)(stack.has(BotaniaDataComponents.ACTIVE) ? "botaniamisc.active" : "botaniamisc.inactive")));
    }

    public static boolean hasTemperanceActive(Player player) {
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !stack.is(BotaniaItems.temperanceStone) || !stack.has(BotaniaDataComponents.ACTIVE)) continue;
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack cursor, Slot slot, ClickAction click, Player player, SlotAccess access) {
        Level world = player.level();
        if (click == ClickAction.SECONDARY && slot.allowModification(player) && cursor.isEmpty()) {
            this.toggleActive(stack, player, world);
            access.set(cursor);
            return true;
        }
        return false;
    }

    private void toggleActive(ItemStack stack, Player player, Level world) {
        DataComponentHelper.setFlag(stack, BotaniaDataComponents.ACTIVE, !stack.has(BotaniaDataComponents.ACTIVE));
        world.playSound(player, player.getX(), player.getY(), player.getZ(), BotaniaSounds.temperanceStoneConfigure, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }
}

