/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.internal_caps.KeptItemsComponent;
import vazkii.botania.xplat.XplatAbstractions;

public class ResoluteIvyItem
extends Item {
    public ResoluteIvyItem(Item.Properties props) {
        super(props);
    }

    public static boolean hasIvy(ItemStack stack) {
        return !stack.isEmpty() && stack.has(BotaniaDataComponents.RESOLUTE_IVY);
    }

    public static void keepDropsOnDeath(Player player) {
        ArrayList<ItemStack> keeps = new ArrayList<ItemStack>();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !stack.has(BotaniaDataComponents.RESOLUTE_IVY)) continue;
            keeps.add(stack);
            player.getInventory().setItem(i, ItemStack.EMPTY);
        }
        KeptItemsComponent data = XplatAbstractions.INSTANCE.keptItemsComponent(player, false);
        data.addAll(keeps);
    }

    public static void onPlayerRespawn(Player oldPlayer, Player newPlayer, boolean alive) {
        if (!alive) {
            KeptItemsComponent keeps = XplatAbstractions.INSTANCE.keptItemsComponent(oldPlayer, true);
            for (ItemStack stack : keeps.getStacks()) {
                ItemStack copy = stack.copy();
                copy.remove(BotaniaDataComponents.RESOLUTE_IVY);
                if (newPlayer.getInventory().add(copy)) continue;
                newPlayer.spawnAtLocation(copy);
            }
        }
    }
}

