/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.PinkWitherEntity;
import vazkii.botania.common.handler.BotaniaSounds;

public class PinkinatorItem
extends Item {
    public PinkinatorItem(Item.Properties builder) {
        super(builder);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        int range = 16;
        List withers = world.getEntitiesOfClass(WitherBoss.class, new AABB(player.getX() - (double)range, player.getY() - (double)range, player.getZ() - (double)range, player.getX() + (double)range, player.getY() + (double)range, player.getZ() + (double)range));
        for (WitherBoss wither : withers) {
            if (!wither.isAlive() || wither instanceof PinkWitherEntity) continue;
            if (!world.isClientSide) {
                wither.discard();
                PinkWitherEntity pink = (PinkWitherEntity)BotaniaEntities.PINK_WITHER.create(world);
                pink.moveTo(wither.getX(), wither.getY(), wither.getZ(), wither.getYRot(), wither.getXRot());
                pink.setNoAi(wither.isNoAi());
                if (wither.hasCustomName()) {
                    pink.setCustomName(wither.getCustomName());
                    pink.setCustomNameVisible(wither.isCustomNameVisible());
                }
                pink.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(pink.blockPosition()), MobSpawnType.CONVERSION, null);
                world.addFreshEntity((Entity)pink);
                pink.spawnAnim();
                pink.playSound(BotaniaSounds.pinkinator, 1.0f, (1.0f + (world.random.nextFloat() - world.random.nextFloat()) * 0.2f) * 0.7f);
                UseItemSuccessTrigger.INSTANCE.trigger((ServerPlayer)player, stack, (ServerLevel)world, player.getX(), player.getY(), player.getZ());
                stack.shrink(1);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add((Component)Component.translatable((String)"botaniamisc.pinkinatorDesc").withStyle(ChatFormatting.GRAY));
    }
}

