/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.DataComponentHelper;
import vazkii.botania.common.item.AssemblyHaloItem;

public class ManufactoryHaloItem
extends AssemblyHaloItem {
    private static final ResourceLocation glowTexture = ResourceLocation.parse((String)"botania:textures/misc/glow1.png");

    public ManufactoryHaloItem(Item.Properties props) {
        super(props);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int pos, boolean equipped) {
        super.inventoryTick(stack, world, entity, pos, equipped);
        if (!world.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            if (!equipped && ManufactoryHaloItem.isActive(stack)) {
                for (int i = 1; i < 12; ++i) {
                    this.tryCraft(player, stack, i, false);
                }
            }
        }
    }

    @Override
    public ResourceLocation getGlowResource(ItemStack stack) {
        return ManufactoryHaloItem.isActive(stack) ? glowTexture : super.getGlowResource(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> stacks, TooltipFlag flags) {
        if (ManufactoryHaloItem.isActive(stack)) {
            stacks.add((Component)Component.translatable((String)"botaniamisc.active"));
        } else {
            stacks.add((Component)Component.translatable((String)"botaniamisc.inactive"));
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (ManufactoryHaloItem.getSegmentLookedAt(stack, (LivingEntity)player) == 0 && player.isSecondaryUseActive()) {
            this.togglePassive(stack, (LivingEntity)player, world);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
        }
        return super.use(world, player, hand);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack cursor, Slot slot, ClickAction click, Player player, SlotAccess access) {
        Level world = player.level();
        if (click == ClickAction.SECONDARY && slot.allowModification(player) && cursor.isEmpty()) {
            this.togglePassive(stack, (LivingEntity)player, world);
            access.set(cursor);
            return true;
        }
        return false;
    }

    private void togglePassive(ItemStack stack, LivingEntity living, Level world) {
        DataComponentHelper.setFlag(stack, BotaniaDataComponents.ACTIVE, !ManufactoryHaloItem.isActive(stack));
        if (living instanceof Player) {
            Player player = (Player)living;
            world.playSound(player, player.getX(), player.getY(), player.getZ(), BotaniaSounds.manufactoryHaloConfigure, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private static boolean isActive(ItemStack stack) {
        return stack.has(BotaniaDataComponents.ACTIVE);
    }
}

