/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.helper.DataComponentHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaTabletItem
extends Item
implements CustomCreativeTabContents {
    public static final int DEFAULT_MAX_MANA = 500000;

    public ManaTabletItem(Item.Properties props) {
        super(props);
    }

    @Override
    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        output.accept((ItemLike)me);
        ItemStack fullPower = new ItemStack((ItemLike)me);
        ManaTabletItem.setMana(fullPower, 500000);
        output.accept(fullPower);
        ItemStack creative = new ItemStack((ItemLike)me);
        ManaTabletItem.setMana(creative, 500000);
        ManaTabletItem.setStackCreative(creative);
        output.accept(creative);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> stacks, TooltipFlag flags) {
        if (ManaTabletItem.isStackCreative(stack)) {
            stacks.add((Component)Component.translatable((String)"botaniamisc.creative").withStyle(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    protected static void setMana(ItemStack stack, int mana) {
        DataComponentHelper.setIntNonZero(stack, BotaniaDataComponents.MANA, mana);
    }

    public static void setStackCreative(ItemStack stack) {
        stack.set(BotaniaDataComponents.CREATIVE_MANA, (Object)Unit.INSTANCE);
        stack.remove(BotaniaDataComponents.CAN_RECEIVE_MANA_FROM_ITEM);
    }

    public static boolean isStackCreative(ItemStack stack) {
        return stack.has(BotaniaDataComponents.CREATIVE_MANA);
    }

    public boolean isBarVisible(ItemStack stack) {
        return !ManaTabletItem.isStackCreative(stack);
    }

    public int getBarWidth(ItemStack stack) {
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(manaItem));
    }

    public int getBarColor(ItemStack stack) {
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        return Mth.hsvToRgb((float)(ManaBarTooltip.getFractionForDisplay(manaItem) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

