/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.ManaPoolMinecartEntity;

public class ManaPoolMinecartItem
extends Item {
    public ManaPoolMinecartItem(Item.Properties builder) {
        super(builder);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockPos;
        Level world = context.getLevel();
        BlockState blockState = world.getBlockState(blockPos = context.getClickedPos());
        if (!blockState.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemStack = context.getItemInHand();
        if (!world.isClientSide) {
            RailShape railShape = blockState.getBlock() instanceof BaseRailBlock ? (RailShape)blockState.getValue(((BaseRailBlock)blockState.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
            double d = 0.0;
            if (railShape.isAscending()) {
                d = 0.5;
            }
            ManaPoolMinecartEntity abstractMinecartEntity = new ManaPoolMinecartEntity(world, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.0625 + d, (double)blockPos.getZ() + 0.5);
            if (itemStack.has(DataComponents.CUSTOM_NAME)) {
                abstractMinecartEntity.setCustomName(itemStack.getHoverName());
            }
            world.addFreshEntity((Entity)abstractMinecartEntity);
        }
        itemStack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }
}

