/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaMirrorItem
extends Item {
    private static final DummyPool fallbackPool = new DummyPool();

    public ManaMirrorItem(Item.Properties props) {
        super(props);
    }

    public boolean isBarVisible(ItemStack stack) {
        return stack.has(BotaniaDataComponents.MANA_POOL_POS);
    }

    public int getBarWidth(ItemStack stack) {
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(manaItem));
    }

    public int getBarColor(ItemStack stack) {
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        return Mth.hsvToRgb((float)(ManaBarTooltip.getFractionForDisplay(manaItem) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world.isClientSide) {
            return;
        }
        ManaPool pool = this.getManaPool(world.getServer(), stack);
        if (!(pool instanceof DummyPool)) {
            if (pool == null) {
                ManaMirrorItem.setMana(stack, 0);
            } else {
                pool.receiveMana(ManaMirrorItem.getManaBacklog(stack));
                ManaMirrorItem.clearManaBacklog(stack);
                ManaMirrorItem.setMana(stack, pool.getCurrentMana());
                ManaMirrorItem.setMaxMana(stack, pool.getMaxMana());
            }
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        ManaReceiver receiver;
        Level world = ctx.getLevel();
        Player player = ctx.getPlayer();
        if (player != null && player.isSecondaryUseActive() && (receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, ctx.getClickedPos(), null)) instanceof ManaPool) {
            ManaPool pool = (ManaPool)receiver;
            if (!world.isClientSide) {
                this.bindPool(ctx.getItemInHand(), pool);
                world.playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.ding, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return InteractionResult.PASS;
    }

    protected static void setMana(ItemStack stack, int mana) {
        stack.set(BotaniaDataComponents.MANA, (Object)mana);
    }

    protected static void setMaxMana(ItemStack stack, int maxMana) {
        stack.set(BotaniaDataComponents.MAX_MANA, (Object)maxMana);
    }

    protected static int getManaBacklog(ItemStack stack) {
        return (Integer)stack.getOrDefault(BotaniaDataComponents.MANA_BACKLOG, (Object)0);
    }

    protected static void clearManaBacklog(ItemStack stack) {
        stack.set(BotaniaDataComponents.MANA_BACKLOG, (Object)0);
    }

    public void bindPool(ItemStack stack, ManaPool pool) {
        GlobalPos pos = GlobalPos.of((ResourceKey)pool.getManaReceiverLevel().dimension(), (BlockPos)pool.getManaReceiverPos());
        stack.set(BotaniaDataComponents.MANA_POOL_POS, (Object)pos);
    }

    @Nullable
    private static GlobalPos getBoundPos(ItemStack stack) {
        return (GlobalPos)stack.get(BotaniaDataComponents.MANA_POOL_POS);
    }

    @Nullable
    private ManaPool getManaPool(@Nullable MinecraftServer server, ItemStack stack) {
        ManaReceiver receiver;
        if (server == null) {
            return fallbackPool;
        }
        GlobalPos pos = ManaMirrorItem.getBoundPos(stack);
        if (pos == null) {
            return fallbackPool;
        }
        ResourceKey type = pos.dimension();
        ServerLevel world = server.getLevel(type);
        if (world != null && (receiver = XplatAbstractions.INSTANCE.findManaReceiver((Level)world, pos.pos(), null)) instanceof ManaPool) {
            ManaPool pool = (ManaPool)receiver;
            return pool;
        }
        return null;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    private static class DummyPool
    implements ManaPool {
        private DummyPool() {
        }

        @Override
        public boolean isFull() {
            return false;
        }

        @Override
        public void receiveMana(int mana) {
        }

        @Override
        public boolean canReceiveManaFromBursts() {
            return false;
        }

        @Override
        public Level getManaReceiverLevel() {
            return null;
        }

        @Override
        public BlockPos getManaReceiverPos() {
            return ManaBurst.NO_SOURCE;
        }

        @Override
        public int getCurrentMana() {
            return 0;
        }

        @Override
        public int getMaxMana() {
            return 0;
        }

        @Override
        public boolean isOutputtingPower() {
            return false;
        }

        @Override
        public Optional<DyeColor> getColor() {
            return Optional.empty();
        }

        @Override
        public void setColor(Optional<DyeColor> color) {
        }
    }

    public static class CoordBoundItemImpl
    implements CoordBoundItem {
        private final ItemStack stack;

        public CoordBoundItemImpl(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        @Nullable
        public BlockPos getBinding(Level world) {
            GlobalPos pos = ManaMirrorItem.getBoundPos(this.stack);
            if (pos == null) {
                return null;
            }
            if (pos.dimension() == world.dimension()) {
                return pos.pos();
            }
            return null;
        }
    }
}

