/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.helper.PlayerHelper;

public class LifeAggregatorItem
extends Item {
    public LifeAggregatorItem(Item.Properties props) {
        super(props);
    }

    public static boolean hasData(ItemStack stack) {
        return stack.has(DataComponents.BLOCK_ENTITY_DATA);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> infoList, TooltipFlag flags) {
        ResourceLocation id = (ResourceLocation)stack.get(BotaniaDataComponents.MOB_TYPE);
        if (id != null) {
            BuiltInRegistries.ENTITY_TYPE.getOptional(id).ifPresent(type -> infoList.add((Component)type.getDescription().copy().withStyle(ChatFormatting.GRAY)));
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        if (LifeAggregatorItem.hasData(ctx.getItemInHand())) {
            return this.placeSpawner(ctx);
        }
        return this.captureSpawner(ctx) ? InteractionResult.sidedSuccess((boolean)ctx.getLevel().isClientSide()) : InteractionResult.PASS;
    }

    private InteractionResult placeSpawner(UseOnContext ctx) {
        ItemStack useStack = new ItemStack((ItemLike)Blocks.SPAWNER);
        Pair<InteractionResult, BlockPos> res = PlayerHelper.substituteUseTrackPos(ctx, useStack);
        if (((InteractionResult)res.getFirst()).consumesAction()) {
            Level world = ctx.getLevel();
            BlockPos pos = (BlockPos)res.getSecond();
            ItemStack mover = ctx.getItemInHand();
            if (!world.isClientSide) {
                BlockEntity blockEntity;
                Player player = ctx.getPlayer();
                if (player != null) {
                    player.onEquippedItemBroken((Item)this, LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
                }
                if ((blockEntity = world.getBlockEntity(pos)) instanceof SpawnerBlockEntity) {
                    blockEntity.loadWithComponents(((CustomData)mover.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag(), (HolderLookup.Provider)world.registryAccess());
                }
                mover.shrink(1);
            } else {
                for (int i = 0; i < 100; ++i) {
                    SparkleParticleData data = SparkleParticleData.sparkle(0.45f + 0.2f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), 6);
                    world.addParticle((ParticleOptions)data, (double)pos.getX() + Math.random(), (double)pos.getY() + Math.random(), (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
                }
            }
        }
        return (InteractionResult)res.getFirst();
    }

    private boolean captureSpawner(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        ItemStack stack = ctx.getItemInHand();
        Player player = ctx.getPlayer();
        if (world.getBlockState(pos).is(Blocks.SPAWNER)) {
            if (!world.isClientSide) {
                SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)world.getBlockEntity(pos);
                Entity displayEntity = spawnerBlockEntity.getSpawner().getOrCreateDisplayEntity(world, pos);
                if (displayEntity != null) {
                    stack.set(BotaniaDataComponents.MOB_TYPE, (Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)displayEntity.getType()));
                }
                stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)spawnerBlockEntity.saveWithoutMetadata((HolderLookup.Provider)world.registryAccess())));
                world.destroyBlock(pos, false);
                if (player != null) {
                    player.getCooldowns().addCooldown((Item)this, 20);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        UseItemSuccessTrigger.INSTANCE.trigger(serverPlayer, stack, serverPlayer.serverLevel(), pos.getX(), pos.getY(), pos.getZ());
                    }
                    player.onEquippedItemBroken((Item)this, LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
                }
            } else {
                for (int i = 0; i < 50; ++i) {
                    float red = (float)Math.random();
                    float green = (float)Math.random();
                    float blue = (float)Math.random();
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.1f + 0.05f, red, green, blue);
                    world.addParticle((ParticleOptions)data, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)((float)(Math.random() - 0.5) * 0.15f), (double)((float)(Math.random() - 0.5) * 0.15f), (double)((float)(Math.random() - 0.5) * 0.15f));
                }
            }
            return true;
        }
        return false;
    }
}

