/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.ItemWithBannerPattern;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.patchouli.api.PatchouliAPI;

public class LexicaBotaniaItem
extends Item
implements ItemWithBannerPattern,
CustomCreativeTabContents {
    public LexicaBotaniaItem(Item.Properties settings) {
        super(settings);
    }

    public static boolean isOpen() {
        return BuiltInRegistries.ITEM.getKey((Object)BotaniaItems.lexicon).equals((Object)PatchouliAPI.get().getOpenBookGui());
    }

    @Override
    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        output.accept((ItemLike)me);
        ItemStack creative = new ItemStack((ItemLike)me);
        creative.set(BotaniaDataComponents.ELVEN_UNLOCK, (Object)Unit.INSTANCE);
        output.accept(creative);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)LexicaBotaniaItem.getEdition().copy().withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)playerIn;
            UseItemSuccessTrigger.INSTANCE.trigger(player, stack, player.serverLevel(), player.getX(), player.getY(), player.getZ());
            PatchouliAPI.get().openBookGUI(player, BuiltInRegistries.ITEM.getKey((Object)this));
            playerIn.playSound(BotaniaSounds.lexiconOpen, 1.0f, (float)(0.7 + Math.random() * 0.4));
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)worldIn.isClientSide());
    }

    public static Component getEdition() {
        try {
            return PatchouliAPI.get().getSubtitle(BuiltInRegistries.ITEM.getKey((Object)BotaniaItems.lexicon));
        }
        catch (IllegalArgumentException e) {
            return Component.literal((String)"");
        }
    }

    public static Component getTitle(ItemStack stack) {
        Component title = stack.getHoverName();
        return title;
    }

    public static boolean isElven(ItemStack stack) {
        return stack.has(BotaniaDataComponents.ELVEN_UNLOCK);
    }

    public static BlockHitResult doRayTrace(Level world, Player player, ClipContext.Fluid fluidMode) {
        return Item.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)fluidMode);
    }

    @Override
    public TagKey<BannerPattern> getBannerPattern() {
        return BotaniaTags.BannerPatterns.PATTERN_ITEM_LEXICON;
    }
}

