/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.HornHarvestable;
import vazkii.botania.common.block.flower.functional.BergamuteBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.XplatAbstractions;

public class HornItem
extends Item {
    public HornItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
    }

    public void onUseTick(Level world, @NotNull LivingEntity living, @NotNull ItemStack stack, int time) {
        if (!world.isClientSide) {
            if (time != this.getUseDuration(stack, living) && time % 5 == 0) {
                living.gameEvent((Holder)GameEvent.INSTRUMENT_PLAY);
                HornItem.breakGrass(world, stack, living.blockPosition(), living);
            }
            world.playSound(null, living.getX(), living.getY(), living.getZ(), BotaniaSounds.hornDoot, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static boolean canHarvest(Level level, ItemStack stack, BlockPos pos, @Nullable LivingEntity user, HornHarvestable.EnumHornType type) {
        BlockEntity be;
        BlockState state = level.getBlockState(pos);
        HornHarvestable harvestable = XplatAbstractions.INSTANCE.findHornHarvestable(level, pos, state, be = level.getBlockEntity(pos));
        if (harvestable != null) {
            return harvestable.canHornHarvest(level, pos, stack, type, user);
        }
        return switch (type) {
            default -> {
                if (state.getBlock() instanceof BushBlock && !state.is(BotaniaTags.Blocks.SPECIAL_FLOWERS) || state.is(BotaniaTags.Blocks.HORN_OF_THE_WILD_BREAKABLE)) {
                    yield true;
                }
                yield false;
            }
            case HornHarvestable.EnumHornType.CANOPY -> {
                if (!(!state.is(BotaniaTags.Blocks.HORN_OF_THE_CANOPY_BREAKABLE) || state.getBlock() instanceof LeavesBlock && ((Boolean)state.getValue((Property)LeavesBlock.PERSISTENT)).booleanValue())) {
                    yield true;
                }
                yield false;
            }
            case HornHarvestable.EnumHornType.COVERING -> state.is(BotaniaTags.Blocks.HORN_OF_THE_COVERING_BREAKABLE);
        };
    }

    public static void breakGrass(Level world, ItemStack stack, BlockPos srcPos, @Nullable LivingEntity user) {
        HornHarvestable.EnumHornType type = null;
        if (stack.is(BotaniaItems.grassHorn)) {
            type = HornHarvestable.EnumHornType.WILD;
        } else if (stack.is(BotaniaItems.leavesHorn)) {
            type = HornHarvestable.EnumHornType.CANOPY;
        } else if (stack.is(BotaniaItems.snowHorn)) {
            type = HornHarvestable.EnumHornType.COVERING;
        }
        int range = 12 - type.ordinal() * 3;
        int rangeY = 3 + type.ordinal() * 4;
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)srcPos.offset(-range, -rangeY, -range), (BlockPos)srcPos.offset(range, rangeY, range))) {
            if (BergamuteBlockEntity.isBergamuteNearby(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) || !HornItem.canHarvest(world, stack, pos, user, type)) continue;
            coords.add(pos.immutable());
        }
        Collections.shuffle(coords);
        int count = Math.min(coords.size(), 32 + type.ordinal() * 16);
        for (int i = 0; i < count; ++i) {
            BlockEntity be;
            BlockState state;
            BlockPos currCoords = (BlockPos)coords.get(i);
            HornHarvestable harvestable = XplatAbstractions.INSTANCE.findHornHarvestable(world, currCoords, state = world.getBlockState(currCoords), be = world.getBlockEntity(currCoords));
            if (harvestable != null && harvestable.hasSpecialHornHarvest(world, currCoords, stack, type, user)) {
                harvestable.harvestByHorn(world, currCoords, stack, type, user);
                continue;
            }
            world.destroyBlock(currCoords, true);
        }
    }
}

