/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;

public class FloralFertilizerItem
extends Item {
    public FloralFertilizerItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        int range = 3;
        if (!world.isClientSide) {
            ArrayList<BlockPos> validCoords = new ArrayList<BlockPos>();
            for (int i = -4; i < 3; ++i) {
                for (int j = -4; j < 3; ++j) {
                    for (int k = 2; k >= -2; --k) {
                        BlockPos pos_ = pos.offset(i + 1, k + 1, j + 1);
                        if (!world.isEmptyBlock(pos_) || world.dimensionType().ultraWarm() && pos_.getY() >= 255 || !BotaniaBlocks.whiteFlower.defaultBlockState().canSurvive((LevelReader)world, pos_)) continue;
                        validCoords.add(pos_);
                    }
                }
            }
            int flowerCount = Math.min(validCoords.size(), world.random.nextBoolean() ? 3 : 4);
            for (int i = 0; i < flowerCount; ++i) {
                BlockPos coords = (BlockPos)validCoords.get(world.random.nextInt(validCoords.size()));
                validCoords.remove(coords);
                world.setBlockAndUpdate(coords, BotaniaBlocks.getFlower(DyeColor.byId((int)world.random.nextInt(16))).defaultBlockState());
            }
            ctx.getItemInHand().shrink(1);
        } else {
            for (int i = 0; i < 15; ++i) {
                double x = (double)(pos.getX() - 3 + world.random.nextInt(7)) + Math.random();
                double y = pos.getY() + 1;
                double z = (double)(pos.getZ() - 3 + world.random.nextInt(7)) + Math.random();
                float red = (float)Math.random();
                float green = (float)Math.random();
                float blue = (float)Math.random();
                WispParticleData data = WispParticleData.wisp(0.15f + (float)Math.random() * 0.25f, red, green, blue, 1.0f);
                world.addParticle((ParticleOptions)data, x, y, z, 0.0, (double)((float)Math.random() * 0.1f - 0.05f), 0.0);
            }
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide());
    }
}

