/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ServerLevelAccessor;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.mixin.AbstractHorseAccessor;

public class EquestrianVirusItem
extends Item {
    public EquestrianVirusItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity living, InteractionHand hand) {
        if (living.isAlive() && living instanceof Horse) {
            Horse horse = (Horse)living;
            if (player.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (horse.isTamed()) {
                SimpleContainer inv = ((AbstractHorseAccessor)horse).getInventory();
                ItemStack saddle = inv.getItem(0);
                if (!saddle.isEmpty() && !saddle.is(Items.SADDLE)) {
                    horse.spawnAtLocation(saddle, 0.0f);
                    saddle = ItemStack.EMPTY;
                }
                for (int i = 1; i < inv.getContainerSize(); ++i) {
                    if (inv.getItem(i).isEmpty()) continue;
                    horse.spawnAtLocation(inv.getItem(i), 0.0f);
                }
                horse.discard();
                AbstractHorse newHorse = stack.is(BotaniaItems.necroVirus) ? (AbstractHorse)EntityType.ZOMBIE_HORSE.create(player.level()) : (AbstractHorse)EntityType.SKELETON_HORSE.create(player.level());
                newHorse.tameWithName(player);
                newHorse.absMoveTo(horse.getX(), horse.getY(), horse.getZ(), horse.getYRot(), horse.getXRot());
                if (!saddle.isEmpty()) {
                    SimpleContainer newInv = ((AbstractHorseAccessor)newHorse).getInventory();
                    newInv.setItem(0, saddle);
                }
                ResourceLocation virusId = BotaniaAPI.botaniaRL("ermergerd_virus");
                AttributeInstance movementSpeed = newHorse.getAttribute(Attributes.MOVEMENT_SPEED);
                movementSpeed.setBaseValue(horse.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue());
                movementSpeed.addPermanentModifier(new AttributeModifier(virusId, movementSpeed.getBaseValue(), AttributeModifier.Operation.ADD_VALUE));
                AttributeInstance health = newHorse.getAttribute(Attributes.MAX_HEALTH);
                health.setBaseValue(horse.getAttribute(Attributes.MAX_HEALTH).getBaseValue());
                health.addPermanentModifier(new AttributeModifier(virusId, health.getBaseValue(), AttributeModifier.Operation.ADD_VALUE));
                AttributeInstance jumpHeight = newHorse.getAttribute(Attributes.JUMP_STRENGTH);
                jumpHeight.setBaseValue(horse.getAttribute(Attributes.JUMP_STRENGTH).getBaseValue());
                jumpHeight.addPermanentModifier(new AttributeModifier(virusId, jumpHeight.getBaseValue() * 0.5, AttributeModifier.Operation.ADD_VALUE));
                newHorse.playSound(BotaniaSounds.virusInfect, 1.0f + living.level().random.nextFloat(), living.level().random.nextFloat() * 0.7f + 1.3f);
                newHorse.finalizeSpawn((ServerLevelAccessor)player.level(), player.level().getCurrentDifficultyAt(newHorse.blockPosition()), MobSpawnType.CONVERSION, null);
                newHorse.setAge(horse.getAge());
                player.level().addFreshEntity((Entity)newHorse);
                newHorse.spawnAnim();
                stack.shrink(1);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static boolean onLivingHurt(LivingEntity entity, DamageSource source) {
        Entity entity2;
        if (entity.isPassenger() && (entity2 = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity vehicle;
            entity = vehicle = (LivingEntity)entity2;
        }
        return (entity instanceof ZombieHorse || entity instanceof SkeletonHorse) && source == entity.damageSources().fall() && ((AbstractHorse)entity).isTamed();
    }
}

