/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;

public class BotaniaArmorMaterials {
    public static final Holder<ArmorMaterial> MANASTEEL = BotaniaArmorMaterials.register("manasteel", Map.of(ArmorItem.Type.BOOTS, 2, ArmorItem.Type.LEGGINGS, 5, ArmorItem.Type.CHESTPLATE, 6, ArmorItem.Type.HELMET, 2), 18, () -> Holder.direct((Object)BotaniaSounds.equipManasteel), () -> Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.manaSteel}), 0.0f);
    public static final Holder<ArmorMaterial> MANAWEAVE = BotaniaArmorMaterials.register("manaweave", Map.of(ArmorItem.Type.BOOTS, 1, ArmorItem.Type.LEGGINGS, 2, ArmorItem.Type.CHESTPLATE, 3, ArmorItem.Type.HELMET, 1), 18, () -> Holder.direct((Object)BotaniaSounds.equipManaweave), () -> Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.manaweaveCloth}), 0.0f);
    public static final Holder<ArmorMaterial> ELEMENTIUM = BotaniaArmorMaterials.register("elementium", Map.of(ArmorItem.Type.BOOTS, 2, ArmorItem.Type.LEGGINGS, 5, ArmorItem.Type.CHESTPLATE, 6, ArmorItem.Type.HELMET, 2), 18, () -> Holder.direct((Object)BotaniaSounds.equipElementium), () -> Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.elementium}), 0.0f);
    public static final Holder<ArmorMaterial> TERRASTEEL = BotaniaArmorMaterials.register("terrasteel", Map.of(ArmorItem.Type.BOOTS, 3, ArmorItem.Type.LEGGINGS, 6, ArmorItem.Type.CHESTPLATE, 8, ArmorItem.Type.HELMET, 3), 26, () -> Holder.direct((Object)BotaniaSounds.equipTerrasteel), () -> Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.terrasteel}), 3.0f);

    private static Holder<ArmorMaterial> register(String name, Map<ArmorItem.Type, Integer> defense, int enchantmentValue, Supplier<Holder<SoundEvent>> equipSound, Supplier<Ingredient> repairIngredient, float toughness) {
        List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(BotaniaAPI.botaniaRL(name)));
        return BotaniaArmorMaterials.register(name, defense, enchantmentValue, equipSound.get(), toughness, repairIngredient, list);
    }

    private static Holder<ArmorMaterial> register(String name, Map<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, Supplier<Ingredient> repairIngredient, List<ArmorMaterial.Layer> layers) {
        EnumMap<ArmorItem.Type, Integer> enummap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type armoritem$type : ArmorItem.Type.values()) {
            enummap.put(armoritem$type, defense.get(armoritem$type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)BotaniaAPI.botaniaRL(name), (Object)new ArmorMaterial(enummap, enchantmentValue, equipSound, repairIngredient, layers, toughness, 0.0f));
    }
}

