/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import vazkii.botania.api.item.ManaDissolvable;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class BlackLotusItem
extends Item
implements ManaDissolvable {
    private static final int MANA_PER = 8000;
    private static final int MANA_PER_T2 = 100000;

    public BlackLotusItem(Item.Properties props) {
        super(props);
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) || stack.is(BotaniaItems.blackerLotus);
    }

    @Override
    public void onDissolveTick(ManaPool pool, ItemEntity item) {
        if (pool.isFull() || pool.getCurrentMana() == 0) {
            return;
        }
        BlockPos pos = pool.getManaReceiverPos();
        boolean t2 = item.getItem().is(BotaniaItems.blackerLotus);
        if (!item.level().isClientSide) {
            pool.receiveMana(t2 ? 100000 : 8000);
            EntityHelper.shrinkItem(item);
            XplatAbstractions.INSTANCE.sendToTracking((Entity)item, new BotaniaEffectPacket(EffectType.BLACK_LOTUS_DISSOLVE, pos.getX(), (double)pos.getY() + 0.5, pos.getZ(), new int[0]));
        }
        item.playSound(BotaniaSounds.blackLotus, 1.0f, t2 ? 0.1f : 1.0f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flags) {
        list.add((Component)Component.translatable((String)"botaniamisc.lotusDesc").withStyle(ChatFormatting.GRAY));
    }
}

