/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.DataComponentHelper;
import vazkii.botania.common.helper.PlayerHelper;

public class BlackHoleTalismanItem
extends Item {
    public BlackHoleTalismanItem(Item.Properties props) {
        super(props);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (BlackHoleTalismanItem.getBlock(stack) != null && player.isSecondaryUseActive()) {
            DataComponentHelper.setFlag(stack, BotaniaDataComponents.ACTIVE, !stack.has(BotaniaDataComponents.ACTIVE));
            player.playSound(BotaniaSounds.blackHoleTalismanConfigure, 1.0f, 1.0f);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        ItemStack toUse;
        InteractionResult result;
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Direction side = ctx.getClickedFace();
        Player player = ctx.getPlayer();
        BlockState state = world.getBlockState(pos);
        ItemStack stack = ctx.getItemInHand();
        if (!state.isAir() && BlackHoleTalismanItem.setBlock(stack, state.getBlock())) {
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        Block bBlock = BlackHoleTalismanItem.getBlock(stack);
        if (bBlock == null) {
            return InteractionResult.PASS;
        }
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof Container) {
            Container container = (Container)tile;
            if (!world.isClientSide) {
                ItemStack toAdd = new ItemStack((ItemLike)bBlock);
                int maxSize = toAdd.getMaxStackSize();
                toAdd.setCount(BlackHoleTalismanItem.remove(stack, maxSize));
                ItemStack remainder = HopperBlockEntity.addItem(null, (Container)container, (ItemStack)toAdd, (Direction)side);
                if (!remainder.isEmpty()) {
                    BlackHoleTalismanItem.add(stack, remainder.getCount());
                }
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if ((player == null || player.getAbilities().instabuild || BlackHoleTalismanItem.getBlockCount(stack) > 0) && (result = PlayerHelper.substituteUse(ctx, toUse = new ItemStack((ItemLike)bBlock))).consumesAction()) {
            if (!world.isClientSide) {
                BlackHoleTalismanItem.remove(stack, 1);
                ItemsRemainingRenderHandler.send(player, toUse, BlackHoleTalismanItem.getBlockCount(stack));
            }
            return result;
        }
        return InteractionResult.PASS;
    }

    public void inventoryTick(ItemStack talisman, Level world, Entity entity, int slot, boolean selected) {
        int i;
        Player player;
        block8: {
            block7: {
                if (!(entity instanceof Player)) break block7;
                player = (Player)entity;
                if (!entity.level().isClientSide && talisman.has(BotaniaDataComponents.ACTIVE)) break block8;
            }
            return;
        }
        Block block = BlackHoleTalismanItem.getBlock(talisman);
        if (block == null) {
            return;
        }
        int highestIdx = -1;
        int[] counts = new int[player.getInventory().getContainerSize() - player.getInventory().armor.size()];
        ItemStack reference = new ItemStack((ItemLike)block.asItem());
        for (i = 0; i < counts.length; ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)reference, (ItemStack)stack)) continue;
            counts[i] = stack.getCount();
            highestIdx = highestIdx == -1 ? i : (counts[i] > counts[highestIdx] && highestIdx > 8 ? i : highestIdx);
        }
        if (highestIdx != -1) {
            for (i = 0; i < counts.length; ++i) {
                int count = counts[i];
                if (count == 0) continue;
                BlackHoleTalismanItem.add(talisman, count);
                player.getInventory().setItem(i, ItemStack.EMPTY);
            }
        }
    }

    public Component getName(ItemStack stack) {
        Block block = BlackHoleTalismanItem.getBlock(stack);
        ItemStack bstack = block == null ? ItemStack.EMPTY : new ItemStack((ItemLike)block);
        MutableComponent cand = super.getName(stack).copy();
        if (!bstack.isEmpty()) {
            cand.append(" (");
            cand.append((Component)bstack.getHoverName().copy().withStyle(ChatFormatting.GREEN));
            cand.append(")");
        }
        return cand;
    }

    public static boolean setBlock(ItemStack stack, Block block) {
        if (block.asItem() != Items.AIR && (BlackHoleTalismanItem.getBlock(stack) == null || BlackHoleTalismanItem.getBlockCount(stack) == 0)) {
            DataComponentHelper.setOptional(stack, BotaniaDataComponents.BLOCK_TYPE, BuiltInRegistries.BLOCK.getKey((Object)block));
            return true;
        }
        return false;
    }

    private static void add(ItemStack stack, int count) {
        int prevCount = BlackHoleTalismanItem.getBlockCount(stack);
        BlackHoleTalismanItem.setCount(stack, (int)Math.min((long)prevCount + (long)count, Integer.MAX_VALUE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> stacks, TooltipFlag flags) {
        Block block = BlackHoleTalismanItem.getBlock(stack);
        if (block != null) {
            int count = BlackHoleTalismanItem.getBlockCount(stack);
            stacks.add((Component)Component.literal((String)(count + " ")).append(new ItemStack((ItemLike)block).getHoverName()).withStyle(ChatFormatting.GRAY));
        }
        stacks.add((Component)Component.translatable((String)(stack.has(BotaniaDataComponents.ACTIVE) ? "botaniamisc.active" : "botaniamisc.inactive")));
    }

    public static void setCount(ItemStack stack, int count) {
        DataComponentHelper.setIntNonZero(stack, BotaniaDataComponents.BLOCK_COUNT, count);
    }

    public static int remove(ItemStack stack, int count) {
        int current = BlackHoleTalismanItem.getBlockCount(stack);
        BlackHoleTalismanItem.setCount(stack, Math.max(current - count, 0));
        return Math.min(current, count);
    }

    @Nullable
    public static Block getBlock(ItemStack stack) {
        ResourceLocation id = (ResourceLocation)stack.get(BotaniaDataComponents.BLOCK_TYPE);
        if (id != null) {
            return BuiltInRegistries.BLOCK.getOptional(id).orElse(null);
        }
        return null;
    }

    public static int getBlockCount(ItemStack stack) {
        return (Integer)stack.getOrDefault(BotaniaDataComponents.BLOCK_COUNT, (Object)0);
    }

    public boolean overrideStackedOnOther(ItemStack talisman, Slot slot, ClickAction clickAction, Player player) {
        Block existingBlock;
        ItemStack toInsert;
        Block blockToInsert;
        if (clickAction == ClickAction.SECONDARY && (blockToInsert = Block.byItem((Item)(toInsert = slot.getItem()).getItem())) != Blocks.AIR && ((existingBlock = BlackHoleTalismanItem.getBlock(talisman)) == null || existingBlock == blockToInsert)) {
            ItemStack taken = slot.safeTake(toInsert.getCount(), Integer.MAX_VALUE, player);
            if (existingBlock == null) {
                BlackHoleTalismanItem.setBlock(talisman, blockToInsert);
                BlackHoleTalismanItem.setCount(talisman, taken.getCount());
            } else {
                BlackHoleTalismanItem.add(talisman, taken.getCount());
            }
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack talisman, ItemStack toInsert, Slot slot, ClickAction clickAction, Player player, SlotAccess cursorAccess) {
        Block existingBlock;
        Block blockToInsert;
        if (clickAction == ClickAction.SECONDARY && (blockToInsert = Block.byItem((Item)toInsert.getItem())) != Blocks.AIR && ((existingBlock = BlackHoleTalismanItem.getBlock(talisman)) == null || existingBlock == blockToInsert)) {
            if (existingBlock == null) {
                BlackHoleTalismanItem.setBlock(talisman, blockToInsert);
                BlackHoleTalismanItem.setCount(talisman, toInsert.getCount());
            } else {
                BlackHoleTalismanItem.add(talisman, toInsert.getCount());
            }
            cursorAccess.set(ItemStack.EMPTY);
            return true;
        }
        return false;
    }

    public static class BlockProviderImpl
    implements BlockProvider {
        private final ItemStack stack;

        public BlockProviderImpl(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public boolean provideBlock(Player player, ItemStack requestor, Block block, boolean doit) {
            int count;
            Block stored = BlackHoleTalismanItem.getBlock(this.stack);
            if (stored == block && (count = BlackHoleTalismanItem.getBlockCount(this.stack)) > 0) {
                if (doit) {
                    BlackHoleTalismanItem.setCount(this.stack, count - 1);
                }
                return true;
            }
            return false;
        }

        @Override
        public int getBlockCount(Player player, ItemStack requestor, Block block) {
            Block stored = BlackHoleTalismanItem.getBlock(this.stack);
            if (stored == block) {
                return BlackHoleTalismanItem.getBlockCount(this.stack);
            }
            return 0;
        }
    }
}

