/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.internal_caps;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.PrimedTnt;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.helper.EthicalTntHelper;
import vazkii.botania.common.internal_caps.SerializableComponent;

public class EthicalComponent
extends SerializableComponent {
    public static final ResourceLocation ID = BotaniaAPI.botaniaRL("tnt_ethical");
    protected static final String TAG_UNETHICAL = "botania:unethical";
    protected boolean unethical;

    public EthicalComponent() {
    }

    public EthicalComponent(PrimedTnt entity) {
        if (!entity.level().isClientSide()) {
            EthicalTntHelper.addTrackedTntEntity(entity);
        }
    }

    public final boolean isUnethical() {
        return this.unethical;
    }

    public final void markUnethical() {
        this.unethical = true;
    }

    @Override
    public void readFromNbt(CompoundTag tag, HolderLookup.Provider registryLookup) {
        this.unethical = tag.getBoolean(TAG_UNETHICAL);
    }

    @Override
    public void writeToNbt(CompoundTag tag, HolderLookup.Provider registryLookup) {
        tag.putBoolean(TAG_UNETHICAL, this.unethical);
    }
}

