/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.mana;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.helper.DataComponentHelper;

public record DefaultManaItemImpl(ItemStack stack) implements ManaItem
{
    @Override
    public int getMana() {
        if (this.stack.has(BotaniaDataComponents.CREATIVE_MANA)) {
            return this.getMaxMana();
        }
        return (Integer)this.stack.getOrDefault(BotaniaDataComponents.MANA, (Object)0);
    }

    @Override
    public int getMaxMana() {
        return (Integer)this.stack.getOrDefault(BotaniaDataComponents.MAX_MANA, (Object)0);
    }

    @Override
    public void addMana(int mana) {
        if (this.stack.has(BotaniaDataComponents.CREATIVE_MANA)) {
            return;
        }
        DataComponentHelper.setIntNonZero(this.stack, BotaniaDataComponents.MANA, Math.min(this.getMana() + mana, this.getMaxMana()));
        Integer manaBacklog = (Integer)this.stack.get(BotaniaDataComponents.MANA_BACKLOG);
        if (manaBacklog != null) {
            this.stack.set(BotaniaDataComponents.MANA_BACKLOG, (Object)(manaBacklog + mana));
        }
    }

    @Override
    public boolean canReceiveManaFromPool(BlockEntity pool) {
        return this.stack.has(BotaniaDataComponents.CAN_RECEIVE_MANA_FROM_POOL);
    }

    @Override
    public boolean canReceiveManaFromItem(ItemStack otherStack) {
        return this.stack.has(BotaniaDataComponents.CAN_RECEIVE_MANA_FROM_ITEM);
    }

    @Override
    public boolean canExportManaToPool(BlockEntity pool) {
        return this.stack.has(BotaniaDataComponents.CAN_EXPORT_MANA_TO_POOL);
    }

    @Override
    public boolean canExportManaToItem(ItemStack otherStack) {
        return this.stack.has(BotaniaDataComponents.CAN_EXPORT_MANA_TO_ITEM);
    }

    @Override
    public boolean isNoExport() {
        return this.stack.has(BotaniaDataComponents.CAN_EXPORT_MANA_TO_ITEM);
    }
}

