/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.corporea;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.common.helper.DataComponentHelper;

public class CorporeaItemStackMatcher
implements CorporeaRequestMatcher {
    private static final String TAG_REQUEST_STACK = "requestStack";
    private static final String TAG_REQUEST_CHECK_NBT = "requestCheckNBT";
    private final ItemStack match;
    private final boolean checkNBT;

    public CorporeaItemStackMatcher(ItemStack match, boolean checkNBT) {
        this.match = match;
        this.checkNBT = checkNBT;
    }

    @Override
    public boolean test(ItemStack stack) {
        return !stack.isEmpty() && !this.match.isEmpty() && ItemStack.isSameItem((ItemStack)stack, (ItemStack)this.match) && (!this.checkNBT || DataComponentHelper.matchTagAndManaFullness(stack, this.match));
    }

    public static CorporeaItemStackMatcher createFromNBT(CompoundTag tag) {
        return new CorporeaItemStackMatcher(ItemStack.EMPTY, tag.getBoolean(TAG_REQUEST_CHECK_NBT));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        CompoundTag cmp = new CompoundTag();
        tag.put(TAG_REQUEST_STACK, (Tag)cmp);
        tag.putBoolean(TAG_REQUEST_CHECK_NBT, this.checkNBT);
    }

    @Override
    public Component getRequestName() {
        return this.match.getDisplayName();
    }
}

