/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.corporea;

import com.google.common.base.Predicates;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaInterceptor;
import vazkii.botania.api.corporea.CorporeaNode;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaResult;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.block.block_entity.corporea.CorporeaRetainerBlockEntity;
import vazkii.botania.common.impl.corporea.CorporeaItemStackMatcher;
import vazkii.botania.common.impl.corporea.CorporeaRequestImpl;
import vazkii.botania.common.impl.corporea.CorporeaResultImpl;
import vazkii.botania.common.impl.corporea.CorporeaStringMatcher;
import vazkii.botania.xplat.XplatAbstractions;

public class CorporeaHelperImpl
implements CorporeaHelper {
    private final WeakHashMap<CorporeaSpark, Set<CorporeaNode>> cachedNetworks = new WeakHashMap();

    @Override
    public Set<CorporeaNode> getNodesOnNetwork(CorporeaSpark spark) {
        CorporeaSpark master = spark.getMaster();
        if (master == null) {
            return Collections.emptySet();
        }
        Set<CorporeaSpark> network = master.getConnections();
        Set<CorporeaNode> cache = this.cachedNetworks.get(master);
        if (cache != null) {
            return cache;
        }
        LinkedHashSet<CorporeaNode> nodes = new LinkedHashSet<CorporeaNode>();
        if (network != null) {
            for (CorporeaSpark otherSpark : network) {
                if (otherSpark == null) continue;
                nodes.add(otherSpark.getSparkNode());
            }
        }
        this.cachedNetworks.put(master, nodes);
        return nodes;
    }

    @Override
    public CorporeaRequestMatcher createMatcher(ItemStack stack, boolean checkNBT) {
        return new CorporeaItemStackMatcher(stack, checkNBT);
    }

    @Override
    public CorporeaRequestMatcher createMatcher(String name) {
        return new CorporeaStringMatcher(name);
    }

    @Override
    public CorporeaResult requestItem(CorporeaRequestMatcher matcher, int itemCount, CorporeaSpark spark, @Nullable LivingEntity entity, boolean doit) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (XplatAbstractions.INSTANCE.fireCorporeaRequestEvent(matcher, itemCount, spark, !doit)) {
            return new CorporeaResultImpl(stacks, 0, 0, (Object2IntMap<CorporeaNode>)Object2IntMaps.emptyMap());
        }
        Object2IntOpenHashMap matchCountByNode = new Object2IntOpenHashMap();
        Set<CorporeaNode> nodes = this.getNodesOnNetwork(spark);
        HashMap<CorporeaInterceptor, CorporeaSpark> interceptors = new HashMap<CorporeaInterceptor, CorporeaSpark>();
        CorporeaRequestImpl request = new CorporeaRequestImpl(matcher, itemCount, entity);
        for (CorporeaNode node : nodes) {
            CorporeaSpark invSpark = node.getSpark();
            BlockEntity te = node.getWorld().getBlockEntity(node.getPos());
            if (te instanceof CorporeaInterceptor) {
                CorporeaInterceptor interceptor = (CorporeaInterceptor)te;
                interceptor.interceptRequest(matcher, itemCount, invSpark, spark, stacks, nodes, doit);
                interceptors.put(interceptor, invSpark);
            }
            List<ItemStack> nodeStacks = doit ? node.extractItems(request) : node.countItems(request);
            int sum = 0;
            for (ItemStack stack : nodeStacks) {
                sum += stack.getCount();
            }
            matchCountByNode.mergeInt((Object)node, sum, Integer::sum);
            stacks.addAll(nodeStacks);
        }
        for (CorporeaInterceptor interceptor : interceptors.keySet()) {
            interceptor.interceptRequestLast(matcher, itemCount, (CorporeaSpark)interceptors.get(interceptor), spark, stacks, nodes, doit);
        }
        return new CorporeaResultImpl(stacks, request.getFound(), request.getExtracted(), (Object2IntMap<CorporeaNode>)matchCountByNode);
    }

    @Override
    public CorporeaSpark getSparkForBlock(Level world, BlockPos pos) {
        List sparks = world.getEntitiesOfClass(Entity.class, new AABB(pos.above()), (Predicate)Predicates.instanceOf(CorporeaSpark.class));
        return sparks.isEmpty() ? null : (CorporeaSpark)sparks.get(0);
    }

    @Override
    public int signalStrengthForRequestSize(int requestSize) {
        if (requestSize <= 0) {
            return 0;
        }
        if (requestSize >= 16384) {
            return 15;
        }
        return Math.min(15, Mth.log2((int)requestSize) + 1);
    }

    @Override
    public <T extends CorporeaRequestMatcher> void registerRequestMatcher(ResourceLocation id, Class<T> clazz, Function<CompoundTag, T> deserializer) {
        CorporeaRetainerBlockEntity.addCorporeaRequestMatcher(id, clazz, deserializer);
    }

    public void clearCache() {
        this.cachedNetworks.clear();
    }
}

