/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.mixin.HopperBlockEntityAccessor;
import vazkii.botania.mixin.InventoryAccessor;

public class InventoryHelper {
    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static ItemStack simulateTransfer(Container to, ItemStack stack, @Nullable Direction side) {
        stack = stack.copy();
        if (to instanceof WorldlyContainer) {
            WorldlyContainer sidedInventory = (WorldlyContainer)to;
            if (side != null) {
                int[] is = sidedInventory.getSlotsForFace(side);
                int i = 0;
                while (i < is.length) {
                    if (stack.isEmpty()) return stack;
                    stack = InventoryHelper.simulateTransfer(to, stack, is[i], side);
                    ++i;
                }
                return stack;
            }
        }
        int j = to.getContainerSize();
        int k = 0;
        while (k < j) {
            if (stack.isEmpty()) return stack;
            stack = InventoryHelper.simulateTransfer(to, stack, k, side);
            ++k;
        }
        return stack;
    }

    private static ItemStack simulateTransfer(Container to, ItemStack stack, int slot, @Nullable Direction direction) {
        ItemStack itemStack = to.getItem(slot);
        if (HopperBlockEntityAccessor.botania_canInsert(to, stack, slot, direction)) {
            boolean bl = false;
            boolean bl2 = to.isEmpty();
            if (itemStack.isEmpty()) {
                stack = ItemStack.EMPTY;
                bl = true;
            } else if (HopperBlockEntityAccessor.botania_canMerge(itemStack, stack)) {
                int i = stack.getMaxStackSize() - itemStack.getCount();
                int j = Math.min(stack.getCount(), i);
                stack.shrink(j);
                bl = j > 0;
            }
        }
        return stack;
    }

    public static void withdrawFromInventory(SimpleInventoryBlockEntity inv, Player player) {
        for (int i = inv.inventorySize() - 1; i >= 0; --i) {
            ItemStack stackAt = inv.getItemHandler().getItem(i);
            if (stackAt.isEmpty()) continue;
            ItemStack copy = stackAt.copy();
            player.getInventory().placeItemBackInInventory(copy);
            inv.getItemHandler().setItem(i, ItemStack.EMPTY);
            inv.getLevel().gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, inv.getBlockPos());
            break;
        }
    }

    public static boolean overrideStackedOnOther(Function<ItemStack, Container> inventoryGetter, boolean selfGuiOpen, @NotNull ItemStack container, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player) {
        if (!selfGuiOpen && clickAction == ClickAction.SECONDARY) {
            ItemStack toInsert = slot.getItem();
            Container inventory = inventoryGetter.apply(container);
            if (InventoryHelper.simulateTransfer(inventory, toInsert, null).isEmpty()) {
                ItemStack taken = slot.safeTake(toInsert.getCount(), Integer.MAX_VALUE, player);
                HopperBlockEntity.addItem(null, (Container)inventory, (ItemStack)taken, null);
                return true;
            }
        }
        return false;
    }

    public static boolean overrideOtherStackedOnMe(Function<ItemStack, Container> inventoryGetter, boolean selfGuiOpen, @NotNull ItemStack container, @NotNull ItemStack toInsert, @NotNull ClickAction clickAction, @NotNull SlotAccess cursorAccess) {
        Container inventory;
        if (!selfGuiOpen && clickAction == ClickAction.SECONDARY && InventoryHelper.simulateTransfer(inventory = inventoryGetter.apply(container), toInsert, null).isEmpty()) {
            HopperBlockEntity.addItem(null, (Container)inventory, (ItemStack)toInsert, null);
            cursorAccess.set(ItemStack.EMPTY);
            return true;
        }
        return false;
    }

    public static void checkEmpty(ItemStack remainder) {
        if (!remainder.isEmpty()) {
            BotaniaAPI.LOGGER.warn("Remainder was not empty after insert, item may have been lost: {}", (Object)remainder);
        }
    }

    public static boolean tryToSetLastRecipe(Player player, Container inv, @Nullable List<ItemStack> lastRecipe, @Nullable SoundEvent sound) {
        if (lastRecipe == null || lastRecipe.isEmpty()) {
            return false;
        }
        int index = 0;
        boolean didAny = false;
        block0: for (ItemStack stack : lastRecipe) {
            if (stack.isEmpty()) continue;
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack pstack = player.getInventory().getItem(i);
                if (!player.isCreative() && (pstack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)pstack))) continue;
                inv.setItem(index, player.isCreative() ? stack.copy() : pstack.split(1));
                didAny = true;
                ++index;
                continue block0;
            }
        }
        if (didAny) {
            if (sound != null) {
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), sound, SoundSource.BLOCKS, 0.1f, 10.0f);
            }
            ServerPlayer mp = (ServerPlayer)player;
            mp.inventoryMenu.broadcastChanges();
        }
        return didAny;
    }

    public static boolean containsType(Inventory inventory, Item item) {
        for (List list : ((InventoryAccessor)inventory).getCompartments()) {
            for (ItemStack stack : list) {
                if (!stack.is(item)) continue;
                return true;
            }
        }
        return false;
    }
}

