/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import java.util.Collection;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.xplat.XplatAbstractions;

public final class DataComponentHelper {
    @Contract(mutates="param1")
    public static void setIntNonZero(ItemStack stack, DataComponentType<Integer> component, int value) {
        if (value == 0) {
            stack.remove(component);
        } else {
            stack.set(component, (Object)value);
        }
    }

    @Contract(mutates="param1")
    public static void setFlag(ItemStack stack, DataComponentType<Unit> component, boolean value) {
        if (value) {
            stack.set(component, (Object)Unit.INSTANCE);
        } else {
            stack.remove(component);
        }
    }

    @Contract(mutates="param1")
    public static <T> void setOptional(ItemStack stack, DataComponentType<? super T> component, @Nullable T value) {
        if (value == null) {
            stack.remove(component);
        } else {
            stack.set(component, value);
        }
    }

    @Contract(mutates="param1")
    public static <T> void setUnlessDefault(ItemStack stack, DataComponentType<? super T> component, @Nullable T value, T defaultValue) {
        if (value == null || value.equals(defaultValue)) {
            stack.remove(component);
        } else {
            stack.set(component, value);
        }
    }

    @Contract(mutates="param1")
    public static <C extends Collection<?>> void setNonEmpty(ItemStack stack, DataComponentType<C> component, @Nullable C collection) {
        if (collection == null || collection.isEmpty()) {
            stack.remove(component);
        } else {
            stack.set(component, collection);
        }
    }

    public static int getFullness(ManaItem item) {
        int mana = item.getMana();
        if (mana == 0) {
            return 0;
        }
        if (mana == item.getMaxMana()) {
            return 2;
        }
        return 1;
    }

    public static ItemStack duplicateAndClearMana(ItemStack stack) {
        ItemStack copy = stack.copy();
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(copy);
        if (manaItem != null) {
            manaItem.addMana(-manaItem.getMana());
        }
        return copy;
    }

    public static boolean matchTagAndManaFullness(ItemStack stack1, ItemStack stack2) {
        if (!ItemStack.isSameItem((ItemStack)stack1, (ItemStack)stack2)) {
            return false;
        }
        ManaItem manaItem1 = XplatAbstractions.INSTANCE.findManaItem(stack1);
        ManaItem manaItem2 = XplatAbstractions.INSTANCE.findManaItem(stack2);
        if (manaItem1 != null && manaItem2 != null) {
            if (DataComponentHelper.getFullness(manaItem1) != DataComponentHelper.getFullness(manaItem2)) {
                return false;
            }
            return ItemStack.matches((ItemStack)DataComponentHelper.duplicateAndClearMana(stack1), (ItemStack)DataComponentHelper.duplicateAndClearMana(stack2));
        }
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }
}

