/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.item.BotaniaItems;

public class VineBallEntity
extends ThrowableProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<Float> GRAVITY = SynchedEntityData.defineId(VineBallEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final Map<Direction, BooleanProperty> propMap = ImmutableMap.of((Object)Direction.NORTH, (Object)VineBlock.NORTH, (Object)Direction.SOUTH, (Object)VineBlock.SOUTH, (Object)Direction.WEST, (Object)VineBlock.WEST, (Object)Direction.EAST, (Object)VineBlock.EAST);

    public VineBallEntity(EntityType<VineBallEntity> type, Level world) {
        super(type, world);
    }

    public VineBallEntity(LivingEntity thrower, boolean gravity) {
        super(BotaniaEntities.VINE_BALL, thrower, thrower.level());
        this.entityData.set(GRAVITY, (Object)Float.valueOf(gravity ? 0.03f : 0.0f));
    }

    public VineBallEntity(double x, double y, double z, Level worldIn) {
        super(BotaniaEntities.VINE_BALL, x, y, z, worldIn);
        this.entityData.set(GRAVITY, (Object)Float.valueOf(0.03f));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(GRAVITY, (Object)Float.valueOf(0.0f));
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int j = 0; j < 16; ++j) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)BotaniaItems.vineBall)), this.getX(), this.getY(), this.getZ(), Math.random() * 0.2 - 0.1, Math.random() * 0.25, Math.random() * 0.2 - 0.1);
            }
        }
    }

    private void effectAndDieWithDrop() {
        this.effectAndDie();
        ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)BotaniaItems.vineBall));
        itemEntity.setDefaultPickUpDelay();
        this.level().addFreshEntity((Entity)itemEntity);
    }

    private void effectAndDie() {
        this.level().broadcastEntityEvent((Entity)this, (byte)3);
        this.discard();
    }

    protected void onHitEntity(@NotNull EntityHitResult hit) {
        super.onHitEntity(hit);
        if (!this.level().isClientSide) {
            this.effectAndDieWithDrop();
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult hit) {
        if (!this.level().isClientSide) {
            Direction dir = hit.getDirection();
            BlockPos pos = hit.getBlockPos();
            BlockState hitState = this.level().getBlockState(hit.getBlockPos());
            if (!hitState.is(BotaniaBlocks.solidVines)) {
                pos = pos.relative(dir);
            }
            int vinesPlaced = 0;
            if (dir.getAxis() != Direction.Axis.Y) {
                while (pos.getY() > this.level().dimensionType().minY() && vinesPlaced < 9) {
                    BlockState state = this.level().getBlockState(pos);
                    if (state.canBeReplaced() && !state.is(BotaniaBlocks.solidVines)) {
                        BlockState stateToPlace = (BlockState)BotaniaBlocks.solidVines.defaultBlockState().setValue((Property)propMap.get(dir.getOpposite()), (Comparable)Boolean.valueOf(true));
                        if (!stateToPlace.canSurvive((LevelReader)this.level(), pos)) break;
                        this.level().setBlockAndUpdate(pos, stateToPlace);
                        this.level().levelEvent(2001, pos, Block.getId((BlockState)stateToPlace));
                        ++vinesPlaced;
                    }
                    if (!this.level().getBlockState(pos).is(BotaniaBlocks.solidVines)) break;
                    pos = pos.below();
                }
            }
            if (vinesPlaced == 0) {
                this.effectAndDieWithDrop();
            } else {
                this.effectAndDie();
            }
        }
    }

    protected double getDefaultGravity() {
        return ((Float)this.entityData.get(GRAVITY)).floatValue();
    }

    @NotNull
    public ItemStack getItem() {
        return new ItemStack((ItemLike)BotaniaItems.vineBall);
    }
}

